/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.message;

import com.jme3.network.AbstractMessage;
import com.jme3.network.message.ChannelInfoMessage;
import com.jme3.network.message.ClientRegistrationMessage;
import com.jme3.network.message.DisconnectMessage;
import com.jme3.network.message.GZIPCompressedMessage;
import com.jme3.network.message.ZIPCompressedMessage;
import com.jme3.network.serializing.Serializable;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.SerializerRegistration;
import com.jme3.network.serializing.serializers.FieldSerializer;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;

@Serializable
public class SerializerRegistrationsMessage
extends AbstractMessage {
    static final Logger log = Logger.getLogger(SerializerRegistrationsMessage.class.getName());
    public static final Set<Class> ignore = new HashSet<Class>();
    public static SerializerRegistrationsMessage INSTANCE;
    public static Registration[] compiled;
    private static final Serializer fieldSerializer;
    private Registration[] registrations;

    public SerializerRegistrationsMessage() {
        this.setReliable(true);
    }

    public SerializerRegistrationsMessage(Registration ... registrations) {
        this.setReliable(true);
        this.registrations = registrations;
    }

    public static void compile() {
        ArrayList<Registration> list = new ArrayList<Registration>();
        for (SerializerRegistration serializerRegistration : Serializer.getSerializerRegistrations()) {
            Class type = serializerRegistration.getType();
            if (ignore.contains(type) || type.isPrimitive()) continue;
            list.add(new Registration(serializerRegistration));
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Number of registered classes:{0}", list.size());
            for (Registration registration : list) {
                log.log(Level.FINE, "    {0}", registration);
            }
        }
        compiled = list.toArray(new Registration[list.size()]);
        INSTANCE = new SerializerRegistrationsMessage(compiled);
        Serializer.setReadOnly(true);
    }

    public void registerAll() {
        if (Serializer.isReadOnly() && compiled != null) {
            log.log(Level.INFO, "Skipping registration as registry is locked, presumably by a local server process.");
            return;
        }
        log.log(Level.FINE, "Registering {0} classes...", this.registrations.length);
        for (Registration reg : this.registrations) {
            log.log(Level.INFO, "Registering:{0}", reg);
            reg.register();
        }
        log.log(Level.FINE, "Done registering serializable classes.");
    }

    static {
        ignore.add(Boolean.class);
        ignore.add(Float.class);
        ignore.add(Boolean.class);
        ignore.add(Byte.class);
        ignore.add(Character.class);
        ignore.add(Short.class);
        ignore.add(Integer.class);
        ignore.add(Long.class);
        ignore.add(Float.class);
        ignore.add(Double.class);
        ignore.add(String.class);
        ignore.add(DisconnectMessage.class);
        ignore.add(ClientRegistrationMessage.class);
        ignore.add(Date.class);
        ignore.add(AbstractCollection.class);
        ignore.add(AbstractList.class);
        ignore.add(AbstractSet.class);
        ignore.add(ArrayList.class);
        ignore.add(HashSet.class);
        ignore.add(LinkedHashSet.class);
        ignore.add(LinkedList.class);
        ignore.add(TreeSet.class);
        ignore.add(Vector.class);
        ignore.add(AbstractMap.class);
        ignore.add(Attributes.class);
        ignore.add(HashMap.class);
        ignore.add(Hashtable.class);
        ignore.add(IdentityHashMap.class);
        ignore.add(TreeMap.class);
        ignore.add(WeakHashMap.class);
        ignore.add(Enum.class);
        ignore.add(GZIPCompressedMessage.class);
        ignore.add(ZIPCompressedMessage.class);
        ignore.add(ChannelInfoMessage.class);
        ignore.add(SerializerRegistrationsMessage.class);
        ignore.add(Registration.class);
        fieldSerializer = new FieldSerializer();
    }

    @Serializable
    public static final class Registration {
        private short id;
        private String className;
        private String serializerClassName;

        public Registration() {
        }

        public Registration(SerializerRegistration reg) {
            this.id = reg.getId();
            this.className = reg.getType().getName();
            if (reg.getSerializer().getClass() != FieldSerializer.class) {
                this.serializerClassName = reg.getSerializer().getClass().getName();
            }
        }

        public void register() {
            try {
                Serializer serializer;
                Class<?> type = Class.forName(this.className);
                if (this.serializerClassName == null) {
                    serializer = fieldSerializer;
                } else {
                    Class<?> serializerType = Class.forName(this.serializerClassName);
                    serializer = (Serializer)serializerType.newInstance();
                }
                SerializerRegistration result = Serializer.registerClassForId(this.id, type, serializer);
                log.log(Level.FINE, "   result:{0}", result);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found attempting to register:" + this, e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Error instantiating serializer registering:" + this, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error instantiating serializer registering:" + this, e);
            }
        }

        public String toString() {
            return "Registration[" + this.id + " = " + this.className + ", serializer=" + this.serializerClassName + "]";
        }
    }
}

