/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.base;

import com.jme3.network.Message;
import com.jme3.network.serializing.Serializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class MessageProtocol {
    private final LinkedList<Message> messages = new LinkedList();
    private ByteBuffer current;
    private int size;
    private Byte carry;

    public static ByteBuffer messageToBuffer(Message message, ByteBuffer target) {
        ByteBuffer buffer = target == null ? ByteBuffer.allocate(32769) : target;
        try {
            buffer.position(2);
            Serializer.writeClassAndObject(buffer, message);
            buffer.flip();
            short dataLength = (short)(buffer.remaining() - 2);
            buffer.putShort(dataLength);
            buffer.position(0);
            return buffer;
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing message", e);
        }
    }

    public Message getMessage() {
        if (this.messages.isEmpty()) {
            return null;
        }
        return this.messages.removeFirst();
    }

    public int addBuffer(ByteBuffer buffer) {
        while (buffer.remaining() > 0) {
            if (this.current == null) {
                if (this.carry != null) {
                    byte high = this.carry;
                    byte low = buffer.get();
                    this.size = (high & 0xFF) << 8 | low & 0xFF;
                    this.carry = null;
                } else {
                    if (buffer.remaining() < 2) {
                        this.carry = buffer.get();
                        break;
                    }
                    this.size = buffer.getShort();
                }
                this.current = ByteBuffer.allocate(this.size);
            }
            if (this.current.remaining() <= buffer.remaining()) {
                int extra = buffer.remaining() - this.current.remaining();
                buffer.limit(buffer.position() + this.current.remaining());
                this.current.put(buffer);
                this.current.flip();
                buffer.limit(buffer.position() + extra);
                this.createMessage(this.current);
                this.current = null;
                continue;
            }
            this.current.put(buffer);
        }
        return this.messages.size();
    }

    protected void createMessage(ByteBuffer buffer) {
        try {
            Object obj = Serializer.readClassAndObject(buffer);
            Message m = (Message)obj;
            this.messages.add(m);
        }
        catch (IOException e) {
            throw new RuntimeException("Error deserializing object, class ID:" + buffer.getShort(0), e);
        }
    }
}

