/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector4f;
import com.jme3.opencl.Buffer;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Device;
import com.jme3.opencl.Event;
import com.jme3.opencl.Image;
import com.jme3.opencl.Kernel;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.lwjgl.LwjglBuffer;
import com.jme3.opencl.lwjgl.LwjglCommandQueue;
import com.jme3.opencl.lwjgl.LwjglDevice;
import com.jme3.opencl.lwjgl.LwjglEvent;
import com.jme3.opencl.lwjgl.LwjglImage;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.opencl.lwjgl.info.Info;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;

public class LwjglKernel
extends Kernel {
    private final long kernel;

    public LwjglKernel(long kernel) {
        super((OpenCLObject.ObjectReleaser)new ReleaserImpl(kernel));
        this.kernel = kernel;
    }

    public long getKernel() {
        return this.kernel;
    }

    public String getName() {
        return Info.clGetKernelInfoStringASCII(this.kernel, 4496);
    }

    public int getArgCount() {
        return Info.clGetKernelInfoInt(this.kernel, 4497);
    }

    public long getMaxWorkGroupSize(Device device) {
        long d = ((LwjglDevice)device).getDevice();
        return Info.clGetKernelWorkGroupInfoPointer(this.kernel, d, 4528);
    }

    public void setArg(int index, Kernel.LocalMemPerElement t) {
        int ret = CL10.clSetKernelArg((long)this.kernel, (int)index, (long)((long)t.getSize() * this.workGroupSize.getSizes()[0] * this.workGroupSize.getSizes()[1] * this.workGroupSize.getSizes()[2]));
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Kernel.LocalMem t) {
        int ret = CL10.clSetKernelArg((long)this.kernel, (int)index, (long)t.getSize());
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Buffer t) {
        int ret = CL10.clSetKernelArg1p((long)this.kernel, (int)index, (long)((LwjglBuffer)t).getBuffer());
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Image i) {
        int ret = CL10.clSetKernelArg1p((long)this.kernel, (int)index, (long)((LwjglImage)i).getImage());
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, byte b) {
        int ret = CL10.clSetKernelArg1b((long)this.kernel, (int)index, (byte)b);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, short s) {
        int ret = CL10.clSetKernelArg1s((long)this.kernel, (int)index, (short)s);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, int i) {
        int ret = CL10.clSetKernelArg1i((long)this.kernel, (int)index, (int)i);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, long l) {
        int ret = CL10.clSetKernelArg1l((long)this.kernel, (int)index, (long)l);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, float f) {
        int ret = CL10.clSetKernelArg1f((long)this.kernel, (int)index, (float)f);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, double d) {
        int ret = CL10.clSetKernelArg1d((long)this.kernel, (int)index, (double)d);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Vector2f v) {
        int ret = CL10.clSetKernelArg2f((long)this.kernel, (int)index, (float)v.x, (float)v.y);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Vector4f v) {
        int ret = CL10.clSetKernelArg4f((long)this.kernel, (int)index, (float)v.x, (float)v.y, (float)v.z, (float)v.w);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Quaternion q) {
        int ret = CL10.clSetKernelArg4f((long)this.kernel, (int)index, (float)q.getX(), (float)q.getY(), (float)q.getZ(), (float)q.getW());
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Matrix4f m) {
        FloatBuffer buf = Utils.b80f;
        buf.position(0);
        buf.limit(16);
        buf.put(m.m00).put(m.m01).put(m.m02).put(m.m03);
        buf.put(m.m10).put(m.m11).put(m.m12).put(m.m13);
        buf.put(m.m20).put(m.m21).put(m.m22).put(m.m23);
        buf.put(m.m30).put(m.m31).put(m.m32).put(m.m33);
        buf.position(0);
        int ret = CL10.clSetKernelArg((long)this.kernel, (int)index, (FloatBuffer)buf);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, ByteBuffer buffer, long size) {
        buffer.limit((int)((long)buffer.position() + size));
        int ret = CL10.clSetKernelArg((long)this.kernel, (int)index, (ByteBuffer)buffer);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public Event Run(CommandQueue queue) {
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[1].put(this.globalWorkSize.getSizes());
        Utils.pointerBuffers[1].position(0);
        PointerBuffer p2 = null;
        if (this.workGroupSize.getSizes()[0] > 0L) {
            p2 = (PointerBuffer)Utils.pointerBuffers[2].rewind();
            p2.put(this.workGroupSize.getSizes());
            p2.position(0);
        }
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueNDRangeKernel((long)q, (long)this.kernel, (int)this.globalWorkSize.getDimension(), null, (PointerBuffer)Utils.pointerBuffers[1], (PointerBuffer)p2, null, (PointerBuffer)Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueNDRangeKernel");
        return new LwjglEvent(Utils.pointerBuffers[0].get(0));
    }

    public void RunNoEvent(CommandQueue queue) {
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[1].put(this.globalWorkSize.getSizes());
        Utils.pointerBuffers[1].position(0);
        PointerBuffer p2 = null;
        if (this.workGroupSize.getSizes()[0] > 0L) {
            p2 = (PointerBuffer)Utils.pointerBuffers[2].rewind();
            p2.put(this.workGroupSize.getSizes());
            p2.position(0);
        }
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueNDRangeKernel((long)q, (long)this.kernel, (int)this.globalWorkSize.getDimension(), null, (PointerBuffer)Utils.pointerBuffers[1], (PointerBuffer)p2, null, null);
        Utils.checkError(ret, "clEnqueueNDRangeKernel");
    }

    public OpenCLObject.ObjectReleaser getReleaser() {
        return new ReleaserImpl(this.kernel);
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private long kernel;

        private ReleaserImpl(long kernel) {
            this.kernel = kernel;
        }

        public void release() {
            if (this.kernel != 0L) {
                int ret = CL10.clReleaseKernel((long)this.kernel);
                this.kernel = 0L;
                Utils.reportError(ret, "clReleaseKernel");
            }
        }
    }
}

