/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.zlmedia.restful;

import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.jetlinks.zlmedia.exception.ZLMediaException;
import org.jetlinks.zlmedia.restful.RestfulClient;
import org.jetlinks.zlmedia.restful.model.ListRtpServer;
import org.jetlinks.zlmedia.rtp.RtpInfo;
import org.jetlinks.zlmedia.rtp.RtpMode;
import org.jetlinks.zlmedia.rtp.RtpOperations;
import org.jetlinks.zlmedia.rtp.SendRtpRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class RestfulRtpOperations
implements RtpOperations {
    final RestfulClient client;

    public Mono<Integer> openRtpServer(String stream, RtpMode mode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tcp_mode", mode.ordinal());
        params.put("stream_id", stream);
        return this.client.request("/index/api/openRtpServer", params, HashMap.class).mapNotNull(map -> {
            if (Objects.equals(0, map.get("code"))) {
                return (Integer)map.get("port");
            }
            throw new ZLMediaException("open rtp server failed:" + map.get("msg"));
        });
    }

    public Mono<Void> closeRtpServer(String stream) {
        return this.client.request("/index/api/closeRtpServer", Collections.singletonMap("stream_id", stream), HashMap.class).then();
    }

    public Flux<RtpInfo> listRtpServer() {
        return this.client.request(new ListRtpServer()).flatMapIterable(resp -> resp.assertSuccess().getDataOrElse(Collections.emptyList()));
    }

    public Mono<Integer> startSendRtp(SendRtpRequest request) {
        return this.client.request("/index/api/startSendRtp", request, HashMap.class).mapNotNull(map -> {
            if (Objects.equals(0, map.get("code"))) {
                return (Integer)map.get("local_port");
            }
            throw new ZLMediaException("start send rtp failed:" + map.get("msg"));
        });
    }

    public Mono<Void> stopSendRtp(String app, String stream) {
        return this.stopSendRtp(app, stream, null);
    }

    public Mono<Void> stopSendRtp(String app, String stream, String ssrc) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("app", app);
        param.put("stream", stream);
        param.put("ssrc", ssrc);
        return this.client.request("/index/api/stopSendRtp", param, HashMap.class).then();
    }

    public RestfulRtpOperations(RestfulClient client) {
        this.client = client;
    }
}

