/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.zlmedia.restful;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import org.jetlinks.zlmedia.exception.ZLMediaException;
import org.jetlinks.zlmedia.restful.RestfulRequest;
import org.jetlinks.zlmedia.restful.RestfulResponse;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

class RestfulClient {
    final ObjectMapper mapper;
    final WebClient http;

    RestfulClient(WebClient client, ObjectMapper mapper) {
        this.mapper = mapper;
        this.http = client;
    }

    <R> Mono<RestfulResponse<R>> request(RestfulRequest<R> request) {
        Object body = request.params();
        if (body != null && !(body instanceof String)) {
            body = this.mapper.writeValueAsString(body);
        }
        return ((WebClient.RequestBodySpec)this.http.post().uri(request.apiAddress(), new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue(body == null ? "{}" : body).exchangeToMono(response -> {
            if (response.statusCode().is2xxSuccessful()) {
                return response.bodyToMono(String.class).map(json -> this.decode((String)json, request));
            }
            return response.bodyToMono(String.class).flatMap(resp -> Mono.error((Throwable)new ZLMediaException(resp)));
        });
    }

    <R> Mono<R> request(String api, Object request, Class<R> responseType) {
        Object body = request;
        if (body != null && !(body instanceof String)) {
            body = this.mapper.writeValueAsString(body);
        }
        return ((WebClient.RequestBodySpec)this.http.post().uri(api, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue(body == null ? "{}" : body).exchangeToMono(response -> {
            if (response.statusCode().is2xxSuccessful()) {
                if (Void.class == responseType) {
                    return response.releaseBody().then(Mono.empty());
                }
                return response.bodyToMono(String.class).map(json -> this.decode((String)json, responseType));
            }
            return response.bodyToMono(String.class).flatMap(resp -> Mono.error((Throwable)new ZLMediaException(resp)));
        });
    }

    <R> R decode(String json, Class<R> responseType) {
        return (R)this.mapper.readValue(json, responseType);
    }

    <R> RestfulResponse<R> decode(String json, final RestfulRequest<R> request) {
        return (RestfulResponse)this.mapper.readValue(json, new TypeReference<RestfulResponse<R>>(){

            public Type getType() {
                return ResolvableType.forClassWithGenerics(RestfulResponse.class, (ResolvableType[])new ResolvableType[]{request.responseType()}).getType();
            }
        });
    }
}

