/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.zlmedia.runner.process;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.jetlinks.zlmedia.ZLMediaOperations;
import org.jetlinks.zlmedia.restful.RestfulZLMediaOperations;
import org.jetlinks.zlmedia.restful.ZLMediaConfigs;
import org.jetlinks.zlmedia.runner.ZLMediaRuntime;
import org.jetlinks.zlmedia.runner.process.ZLMediaProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class ProcessZLMediaRuntime
implements ZLMediaRuntime {
    private static final Logger log = LoggerFactory.getLogger(ProcessZLMediaRuntime.class);
    private final String processFile;
    private Process process;
    private final Sinks.Many<String> output = Sinks.many().unicast().onBackpressureBuffer();
    private final Disposable.Composite disposable = Disposables.composite();
    private final Sinks.One<Void> startAwait = Sinks.one();
    private int restartCount;
    private final ZLMediaOperations operations;
    private final Map<String, String> configs = new ConcurrentHashMap<String, String>();

    public ProcessZLMediaRuntime(String processFile) {
        this(processFile, new ZLMediaConfigs());
    }

    public ProcessZLMediaRuntime(String processFile, ZLMediaConfigs configs) {
        this(processFile, WebClient.builder(), new ObjectMapper(), configs);
    }

    private static void storeInit(Map<String, String> conf, File path) {
        Configurations configs = new Configurations();
        INIConfiguration ini = configs.ini(path);
        conf.forEach((arg_0, arg_1) -> ((INIConfiguration)ini).setProperty(arg_0, arg_1));
        FileWriter fileWriter = new FileWriter(path);
        ini.write((Writer)fileWriter);
        fileWriter.close();
        ini.clear();
    }

    public ProcessZLMediaRuntime(String processFile, WebClient.Builder builder, ObjectMapper mapper, ZLMediaConfigs configs) {
        this.processFile = processFile;
        this.configs.putAll(configs.createConfigs());
        String secure = configs.getSecret();
        this.operations = new RestfulZLMediaOperations(builder.clone().baseUrl("http://127.0.0.1:" + configs.getPorts().getHttp()).filter((request, exchange) -> exchange.exchange(ClientRequest.from((ClientRequest)request).url(UriComponentsBuilder.fromUri((URI)request.url()).queryParam("secret", new Object[]{secure}).build().toUri()).build())).build(), configs, mapper);
    }

    @Override
    public Mono<Void> start() {
        return Mono.fromRunnable(this::start0).subscribeOn(Schedulers.boundedElastic()).then(this.startAwait.asMono());
    }

    protected long getPid() {
        try {
            if (this.process.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field f = this.process.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                return f.getLong(this.process);
            }
            return -1L;
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    protected synchronized void start0() {
        File file = new File(this.processFile);
        if (this.isDisposed() || this.process != null) {
            return;
        }
        ProcessZLMediaRuntime.storeInit(this.configs, new File(new File(this.processFile).getParent(), "config.ini"));
        Path pidFile = Paths.get(this.processFile + ".pid", new String[0]);
        if (pidFile.toFile().exists()) {
            try {
                String pid = new String(Files.readAllBytes(pidFile));
                log.warn("zlmedia process already exists, kill it:{}", (Object)pid);
                Runtime.getRuntime().exec(new String[]{"kill", pid}).waitFor();
            }
            catch (Throwable e) {
                log.warn("kill zlmedia process error", e);
            }
        }
        this.process = new ProcessBuilder(new String[0]).command(file.getAbsolutePath()).directory(file.getParentFile()).redirectErrorStream(true).inheritIO().start();
        long pid = this.getPid();
        if (pid > 0L) {
            Files.write(pidFile, String.valueOf(pid).getBytes(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            pidFile.toFile().deleteOnExit();
            this.disposable.add(() -> {
                boolean ignore = pidFile.toFile().delete();
            });
        }
        this.disposable.add(Mono.fromCallable(() -> {
            try {
                this.processExit(this.process.waitFor());
            }
            catch (InterruptedException ignore) {
                this.processExit(-1);
            }
            return null;
        }).subscribeOn(Schedulers.boundedElastic()).subscribe());
        this.disposable.add(Flux.interval((Duration)Duration.ofSeconds(2L), (Duration)Duration.ofSeconds(1L)).onBackpressureDrop().concatMap(ignore -> this.operations.opsForState().isAlive()).filter(Boolean::booleanValue).take(1L).subscribe(ignore -> {
            this.restartCount = 0;
            this.startAwait.tryEmitEmpty();
        }));
        if (this.isDisposed()) {
            this.process.destroy();
        }
    }

    private void handleOutput(String line) {
        this.output.tryEmitNext((Object)line);
    }

    protected void processExit(int code) {
        if (this.disposable.isDisposed()) {
            return;
        }
        if (this.startAwait.currentSubscriberCount() > 0) {
            this.startAwait.tryEmitError((Throwable)((Object)new ZLMediaProcessException(code, "ZLMediaKit start failed,code:" + code)));
        } else {
            log.warn("ZLMediaKit exit with code:{}", (Object)code);
        }
        if (this.restartCount > 10) {
            log.error("ZLMediaKit exit with code:{},restart count > 10,stop restart", (Object)code);
            return;
        }
        this.process = null;
        ++this.restartCount;
        Schedulers.boundedElastic().schedule(() -> {
            if (this.disposable.isDisposed()) {
                return;
            }
            this.start0();
        }, 2L, TimeUnit.SECONDS);
    }

    @Override
    public Flux<String> output() {
        return this.output.asFlux();
    }

    @Override
    public ZLMediaOperations getOperations() {
        return this.operations;
    }

    public void dispose() {
        this.disposable.dispose();
        if (null != this.process) {
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

