/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.zlmedia.hook;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetlinks.zlmedia.hook.HookEvent;
import org.jetlinks.zlmedia.hook.HookListener;
import org.jetlinks.zlmedia.hook.HookOperations;
import org.jetlinks.zlmedia.hook.HookResponse;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractHookOperations
implements HookOperations {
    private final Map<Class<?>, List<HookListener<?, ?>>> listenerRepository = new ConcurrentHashMap();

    protected final <E extends HookEvent<R>, R extends HookResponse> Mono<R> fireEvent(E event) {
        List<HookListener<?, ?>> listeners = this.listenerRepository.get(event.getClass());
        if (listeners != null) {
            return Flux.fromIterable(listeners).concatMap(listener -> listener.fire(event)).takeLast(1).singleOrEmpty();
        }
        return Mono.empty();
    }

    @Override
    public final <E extends HookEvent<R>, R extends HookResponse> Disposable on(Class<E> type, HookListener<E, R> handler) {
        this.listenerRepository.computeIfAbsent(type, ignore -> new CopyOnWriteArrayList()).add(handler);
        this.onListen(type);
        return () -> this.listenerRepository.compute(type, (ignore, list) -> {
            if (list == null) {
                return null;
            }
            list.remove(handler);
            if (list.isEmpty()) {
                return null;
            }
            return list;
        });
    }

    protected void onListen(Class<? extends HookEvent<?>> type) {
    }
}

