/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nonnull;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.SignalType;
import reactor.util.context.Context;

public class ByteBufUtils {
    public static Flux<ByteBuf> splitByteBuf(ByteBuf data, int maxChunkSize) {
        int length = data.readableBytes();
        if (length <= maxChunkSize) {
            return Flux.just((Object)data);
        }
        return Flux.generate(() -> data, (buf, sink) -> {
            int readableBytes = buf.readableBytes();
            if (readableBytes == 0) {
                sink.complete();
                return buf;
            }
            if (readableBytes > maxChunkSize) {
                sink.next((Object)buf.retainedSlice(buf.readerIndex(), maxChunkSize));
                return buf.readerIndex(buf.readerIndex() + maxChunkSize);
            }
            sink.next((Object)buf.retainedSlice(buf.readerIndex(), buf.readableBytes()));
            sink.complete();
            return buf.readerIndex(buf.readableBytes());
        }, ReferenceCountUtil::safeRelease);
    }

    public static int computeBalanceEachSize(long fileLength, int lengthEachPart) {
        if (fileLength == 0L) {
            return lengthEachPart;
        }
        long parts = fileLength / (long)lengthEachPart;
        int eachSize = parts == 0L ? (int)fileLength : (int)(fileLength / parts);
        long eachRemainder = fileLength % (long)eachSize;
        if (eachRemainder > 0L) {
            eachSize += (int)Math.ceil((double)eachRemainder / (double)parts);
        }
        return eachSize;
    }

    public static Flux<ByteBuf> balanceBuffer(Flux<ByteBuf> buffer, int fixedLength) {
        return new ByteBufBalancer(fixedLength, buffer).onBackpressureBuffer().doOnDiscard(ByteBuf.class, ReferenceCountUtil::safeRelease);
    }

    static class ByteBufBalancerSubscriber
    extends BaseSubscriber<ByteBuf> {
        static final AtomicIntegerFieldUpdater<ByteBufBalancerSubscriber> COUNT = AtomicIntegerFieldUpdater.newUpdater(ByteBufBalancerSubscriber.class, "count");
        private final int fixedLength;
        private volatile int count;
        private final List<ByteBuf> buffer = new ArrayList<ByteBuf>(16);
        private final CoreSubscriber<? super ByteBuf> actual;

        ByteBufBalancerSubscriber(int fixedLength, CoreSubscriber<? super ByteBuf> actual) {
            this.actual = actual;
            this.fixedLength = this.count = fixedLength;
        }

        @Nonnull
        public Context currentContext() {
            return this.actual.currentContext();
        }

        protected void hookOnSubscribe(@Nonnull Subscription subscription) {
            this.actual.onSubscribe((Subscription)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void hookOnNext(@Nonnull ByteBuf buf) {
            int readableBytes = buf.readableBytes();
            if (readableBytes > this.fixedLength) {
                try {
                    int chunk = readableBytes / this.fixedLength;
                    int remainder = readableBytes % this.fixedLength;
                    for (int i = 0; i < chunk; ++i) {
                        this.hookOnNext0(buf.retainedSlice(i * this.fixedLength, this.fixedLength));
                    }
                    if (remainder > 0) {
                        this.hookOnNext0(buf.retainedSlice(readableBytes - remainder, remainder));
                    }
                }
                finally {
                    this.request(1L);
                    ReferenceCountUtil.safeRelease((Object)buf);
                }
                return;
            }
            this.hookOnNext0(buf);
            this.request(1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void hookOnNext0(ByteBuf buf) {
            int remainderLen;
            int readableBytes = buf.readableBytes();
            int remainder = COUNT.addAndGet(this, -readableBytes);
            if (remainder > 0) {
                this.buffer.add(buf);
                return;
            }
            ArrayList<ByteBuf> _temp = new ArrayList<ByteBuf>(this.buffer);
            this.buffer.clear();
            int sliceBytes = readableBytes + remainder;
            if (sliceBytes > 0) {
                _temp.add(buf.retainedSlice(0, sliceBytes));
            }
            if ((remainderLen = readableBytes - sliceBytes) > 0) {
                ByteBuf remainderBuf = buf.retainedSlice(sliceBytes, remainderLen);
                this.buffer.add(remainderBuf);
            }
            COUNT.set(this, this.fixedLength - remainderLen);
            try {
                this.next(_temp);
            }
            finally {
                buf.release();
            }
        }

        protected void next(List<ByteBuf> buffers) {
            int size = buffers.size();
            if (size == 1) {
                this.actual.onNext((Object)buffers.get(0));
            } else if (size > 1) {
                this.actual.onNext((Object)Unpooled.compositeBuffer((int)buffers.size()).addComponents(true, buffers));
            }
        }

        protected void hookFinally(@Nonnull SignalType type) {
            if (!this.buffer.isEmpty()) {
                for (ByteBuf byteBuf : this.buffer) {
                    ReferenceCountUtil.safeRelease((Object)byteBuf);
                }
                this.buffer.clear();
            }
        }

        protected void hookOnComplete() {
            if (!this.buffer.isEmpty()) {
                this.next(new ArrayList<ByteBuf>(this.buffer));
                this.buffer.clear();
            }
            this.actual.onComplete();
        }

        protected void hookOnError(@Nonnull Throwable throwable) {
            this.actual.onError(throwable);
        }
    }

    static class ByteBufBalancer
    extends FluxOperator<ByteBuf, ByteBuf> {
        final int fixedLength;

        protected ByteBufBalancer(int fixedLength, Flux<? extends ByteBuf> source) {
            super(source);
            this.fixedLength = fixedLength;
        }

        public void subscribe(@Nonnull CoreSubscriber<? super ByteBuf> actual) {
            this.source.subscribe((CoreSubscriber)new ByteBufBalancerSubscriber(this.fixedLength, actual));
        }
    }
}

