/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.commons.enums;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.hswebframework.web.dict.EnumDict;
import org.jetlinks.core.utils.SerializeUtils;

public class EnumInfo<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private T value;
    private String text;

    public static <T> EnumInfo<T> of(EnumDict<T> dic) {
        return EnumInfo.of(dic.getValue(), dic.getText());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeObject(this.value, (ObjectOutput)out);
        out.writeUTF(this.text);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = SerializeUtils.readObject((ObjectInput)in);
        this.text = in.readUTF();
    }

    public T getValue() {
        return this.value;
    }

    public String getText() {
        return this.text;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setText(String text) {
        this.text = text;
    }

    public EnumInfo() {
    }

    private EnumInfo(T value, String text) {
        this.value = value;
        this.text = text;
    }

    public static <T> EnumInfo<T> of(T value, String text) {
        return new EnumInfo<T>(value, text);
    }
}

