/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.commons.cmd;

import java.util.Arrays;
import java.util.List;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.sdk.server.commons.cmd.QueryCommand;
import org.jetlinks.sdk.server.utils.CastUtils;

public abstract class AbstractExportCommand<T, Self extends AbstractExportCommand<T, Self>>
extends QueryCommand<T, Self> {
    public static final String FORMAT_JSON = "json";
    public static final String FORMAT_CSV = "csv";
    public static final String FORMAT_XLSX = "xlsx";
    public static final String PARAM_FORMAT = "format";
    public static final String PARAM_TEMPLATE = "template";

    public String format(String defaultFormat) {
        return (String)this.readable().getOrDefault(PARAM_FORMAT, defaultFormat);
    }

    public boolean isTemplate() {
        return CastUtils.castBoolean(this.readable().getOrDefault(PARAM_TEMPLATE, false));
    }

    public static List<PropertyMetadata> getParameterMetadata() {
        return Arrays.asList(SimplePropertyMetadata.of((String)PARAM_FORMAT, (String)"\u6587\u4ef6\u683c\u5f0f", (DataType)new EnumType().addElement(EnumType.Element.of((String)FORMAT_XLSX, (String)FORMAT_XLSX)).addElement(EnumType.Element.of((String)FORMAT_CSV, (String)FORMAT_CSV)).addElement(EnumType.Element.of((String)FORMAT_JSON, (String)FORMAT_JSON))), SimplePropertyMetadata.of((String)PARAM_TEMPLATE, (String)"\u662f\u5426\u53ea\u83b7\u53d6\u6a21\u7248", (DataType)BooleanType.GLOBAL), AbstractExportCommand.getTermsMetadata(), SimplePropertyMetadata.of((String)"sorts", (String)"\u6392\u5e8f", (DataType)new ArrayType().elementType((DataType)new ObjectType().addProperty("name", "\u5217\u540d(\u5c5e\u6027\u540d)", (DataType)StringType.GLOBAL).addProperty("order", "\u6392\u5e8f\u65b9\u5f0f,\u5982:asc,desc", (DataType)StringType.GLOBAL))));
    }
}

