/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.utils;

import com.fasterxml.jackson.databind.ObjectReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.api.crud.entity.TermExpressionParser;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.sdk.server.utils.ObjectMappers;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;

public class ConverterUtils {
    static final ObjectReader termReader = ObjectMappers.JSON_MAPPER.readerForListOf(Term.class);
    private static final NettyDataBufferFactory factory = new NettyDataBufferFactory(ByteBufAllocator.DEFAULT);

    public static Object tryConvertToList(Object value, Function<Object, Object> converter) {
        List<Object> list = ConverterUtils.convertToList(value, converter);
        if (list.size() == 1) {
            return converter.apply(list.get(0));
        }
        return list;
    }

    public static <T> List<T> convertToList(Object value, Function<Object, T> converter) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof String) {
            String[] arr = ((String)value).split(",");
            if (arr.length == 1) {
                return Collections.singletonList(converter.apply(arr[0]));
            }
            ArrayList<T> list = new ArrayList<T>(arr.length);
            for (String s : arr) {
                list.add(converter.apply(s));
            }
            return list;
        }
        if (value instanceof Collection) {
            ArrayList<T> list = new ArrayList<T>(((Collection)value).size());
            for (Object o : (Collection)value) {
                list.add(converter.apply(o));
            }
            return list;
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            ArrayList<T> list = new ArrayList<T>(len);
            for (int i = 0; i < len; ++i) {
                list.add(converter.apply(Array.get(value, i)));
            }
            return list;
        }
        return Collections.singletonList(converter.apply(value));
    }

    public static List<Object> convertToList(Object value) {
        return ConverterUtils.convertToList(value, Function.identity());
    }

    public static String[] convertMapToTags(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            return new String[0];
        }
        String[] tags = new String[map.size() * 2];
        int index = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            String strValue = value instanceof String ? String.valueOf(value) : ObjectMappers.JSON_MAPPER.writeValueAsString(value);
            tags[index++] = key;
            tags[index++] = strValue;
        }
        if (tags.length > index) {
            return Arrays.copyOf(tags, index);
        }
        return tags;
    }

    public static List<Term> convertTerms(Object value) {
        if (value instanceof String) {
            String strVal = String.valueOf(value);
            if (strVal.startsWith("[")) {
                return (List)termReader.readValue(strVal);
            }
            if (strVal.startsWith("{")) {
                return TermExpressionParser.parse((Map)ObjectMappers.parseJson(strVal, Map.class));
            }
            return TermExpressionParser.parse((String)strVal);
        }
        if (value instanceof List) {
            return ((List)value).stream().map(obj -> obj instanceof Term ? (Term)obj : (Term)FastBeanCopier.copy((Object)obj, (Object)new Term(), (String[])new String[0])).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            return TermExpressionParser.parse((Map)((Map)value));
        }
        throw new UnsupportedOperationException("unsupported term value:" + value);
    }

    public static DataBuffer convertDataBuffer(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof DataBuffer) {
            return (DataBuffer)obj;
        }
        return factory.wrap(ConverterUtils.convertNettyBuffer(obj));
    }

    public static <T> ByteBuf convertNettyBuffer(T obj, Function<T, ByteBuf> fallback) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ByteBuf) {
            return (ByteBuf)obj;
        }
        if (obj instanceof byte[]) {
            return Unpooled.wrappedBuffer((byte[])((byte[])obj));
        }
        if (obj instanceof NettyDataBuffer) {
            return ((NettyDataBuffer)obj).getNativeBuffer();
        }
        if (obj instanceof DataBuffer) {
            return Unpooled.wrappedBuffer((ByteBuffer)((DataBuffer)obj).asByteBuffer());
        }
        if (obj instanceof ByteBuffer) {
            return Unpooled.wrappedBuffer((ByteBuffer)((ByteBuffer)obj));
        }
        if (obj instanceof String) {
            String str = String.valueOf(obj);
            if (str.startsWith("0x")) {
                return Unpooled.wrappedBuffer((byte[])ByteBufUtil.decodeHexDump((CharSequence)str, (int)2, (int)(str.length() - 2)));
            }
            if (str.startsWith("data:")) {
                return Unpooled.wrappedBuffer((byte[])Base64.getDecoder().decode(str.substring(str.indexOf(",") + 1)));
            }
            byte[] strBytes = str.getBytes();
            if (org.apache.commons.codec.binary.Base64.isBase64((byte[])strBytes)) {
                try {
                    return Unpooled.wrappedBuffer((byte[])Base64.getDecoder().decode(strBytes));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return Unpooled.wrappedBuffer((byte[])strBytes);
        }
        return fallback.apply(obj);
    }

    public static ByteBuf convertNettyBuffer(Object obj) {
        return ConverterUtils.convertNettyBuffer(obj, val -> Unpooled.wrappedBuffer((byte[])String.valueOf(val).getBytes()));
    }
}

