/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.core.trace.TraceHolder;
import org.jetlinks.core.utils.Reactors;
import org.jetlinks.rule.engine.api.RuleConstants;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.task.ConditionEvaluator;
import org.jetlinks.rule.engine.api.task.Output;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractOutput
implements Output {
    protected final String instanceId;
    private final List<ScheduleJob.Output> outputs;
    private final ConditionEvaluator evaluator;
    private Function<RuleData, Mono<Boolean>> writer;

    public AbstractOutput(String instanceId, List<ScheduleJob.Output> outputs, ConditionEvaluator evaluator) {
        this.instanceId = instanceId;
        this.outputs = outputs;
        this.evaluator = evaluator;
        this.prepare();
    }

    private void prepare() {
        if (CollectionUtils.isEmpty(this.outputs)) {
            this.writer = data -> Reactors.ALWAYS_TRUE;
        } else {
            ArrayList<Function<RuleData, Mono>> writers = new ArrayList<Function<RuleData, Mono>>(this.outputs.size());
            for (ScheduleJob.Output output : this.outputs) {
                Function<RuleData, Mono> writer;
                CharSequence address = this.createOutputAddress(output.getOutput());
                if (output.getCondition() != null) {
                    Function<RuleData, Mono<Boolean>> condition = this.evaluator.prepare(output.getCondition());
                    writer = data -> ((Mono)condition.apply((RuleData)data)).flatMap(passed -> {
                        if (passed.booleanValue()) {
                            return this.doWrite(address, (RuleData)data);
                        }
                        return Reactors.ALWAYS_FALSE;
                    });
                } else {
                    writer = data -> this.doWrite(address, (RuleData)data);
                }
                writers.add(writer);
            }
            Flux flux = Flux.fromIterable(writers);
            this.writer = data -> TraceHolder.writeContextTo((Object)data, RuleData::setHeader).flatMap(ruleData -> flux.flatMap(writer -> ((Mono)writer.apply(ruleData)).onErrorResume(err -> Reactors.ALWAYS_FALSE)).reduce(Boolean::logicalAnd));
        }
    }

    @Override
    public final Mono<Boolean> write(RuleData data) {
        return this.writer.apply(data);
    }

    @Override
    public final Mono<Boolean> write(Publisher<RuleData> dataStream) {
        return Flux.from(dataStream).flatMap(this::write).reduce(Boolean::logicalAnd);
    }

    @Override
    public final Mono<Void> write(String nodeId, Publisher<RuleData> data) {
        return this.doWrite(this.createOutputAddress(nodeId), data).then();
    }

    protected abstract Mono<Boolean> doWrite(CharSequence var1, Publisher<RuleData> var2);

    protected abstract Mono<Boolean> doWrite(CharSequence var1, RuleData var2);

    @Override
    public final Mono<Void> write(String nodeId, RuleData data) {
        return this.doWrite(this.createOutputAddress(nodeId), data).then();
    }

    protected CharSequence createOutputAddress(String nodeId) {
        return RuleConstants.Topics.input(this.instanceId, nodeId);
    }
}

