/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.group;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.GroupFeature;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class GroupByBinaryFeature
implements GroupFeature {
    private final String id;
    private final BiFunction<Object, Object, Object> mapper;

    public GroupByBinaryFeature(String type, BiFunction<Object, Object, Object> mapper) {
        this.id = FeatureId.GroupBy.of(type).getId();
        this.mapper = mapper;
    }

    @Override
    public Function<Flux<ReactorQLRecord>, Flux<Flux<ReactorQLRecord>>> createGroupMapper(Expression expression, ReactorQLMetadata metadata) {
        Tuple2<Function<ReactorQLRecord, Publisher<?>>, Function<ReactorQLRecord, Publisher<?>>> tuple2 = ValueMapFeature.createBinaryMapper(expression, metadata);
        Function leftMapper = (Function)tuple2.getT1();
        Function rightMapper = (Function)tuple2.getT2();
        return flux -> flux.flatMap(ctx -> Mono.zip((Mono)Mono.from((Publisher)((Publisher)leftMapper.apply(ctx))), (Mono)Mono.from((Publisher)((Publisher)rightMapper.apply(ctx))), this.mapper).zipWith(Mono.just((Object)ctx))).groupBy(Tuple2::getT1, tp2 -> GroupFeature.writeGroupKey((ReactorQLRecord)tp2.getT2(), tp2.getT1()), Integer.MAX_VALUE).map(Function.identity());
    }

    @Override
    public String getId() {
        return this.id;
    }
}

