/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.plugin.internal.ai;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hswebframework.ezorm.core.dsl.Query;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.plugin.core.AbstractPlugin;
import org.jetlinks.plugin.core.PluginContext;
import org.jetlinks.plugin.internal.ai.AiModel;
import org.jetlinks.plugin.internal.ai.command.AddAiModelCommand;
import org.jetlinks.plugin.internal.ai.command.GetAiDomainCommand;
import org.jetlinks.plugin.internal.ai.command.GetAiOutputMetadataCommand;
import org.jetlinks.plugin.internal.ai.command.RemoveAiModelCommand;
import org.jetlinks.sdk.server.ai.AICommandHandler;
import org.jetlinks.sdk.server.ai.AiDomain;
import org.jetlinks.sdk.server.ai.model.AiModelInfo;
import org.jetlinks.sdk.server.ai.model.AiModelPortrait;
import org.jetlinks.sdk.server.commons.cmd.QueryListCommand;
import org.jetlinks.sdk.server.file.DownloadFileCommand;
import org.jetlinks.sdk.server.utils.ConverterUtils;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBufferUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AiPlugin
extends AbstractPlugin {
    protected final CommandSupport modelManager = this.getService("aiService:modelManager");
    protected final CommandSupport fileService = this.getService("fileService");

    public AiPlugin(String id, PluginContext context) {
        super(id, context);
        this.registerHandler(GetAiDomainCommand.class, CommandHandler.of((FunctionMetadata)GetAiDomainCommand.metadata(), (ignore, that) -> Mono.just((Object)this.getDomain()), GetAiDomainCommand::new));
        this.registerHandler(AddAiModelCommand.class, CommandHandler.of((FunctionMetadata)AddAiModelCommand.metadata(), (cmd, that) -> this.addModel(cmd.getModel()), AddAiModelCommand::new));
        this.registerHandler(RemoveAiModelCommand.class, CommandHandler.of((FunctionMetadata)RemoveAiModelCommand.metadata(), (cmd, that) -> this.removeModel(cmd.getId()), RemoveAiModelCommand::new));
        this.registerHandler(GetAiOutputMetadataCommand.class, GetAiOutputMetadataCommand.createHandler(this::getAiOutputPropertyMetadata));
    }

    public abstract AiDomain getDomain();

    public abstract Mono<AiModelPortrait> addModel(AiModelInfo var1);

    public abstract Mono<Void> removeModel(String var1);

    protected CommandSupport getService(String service) {
        return (CommandSupport)this.context().services().getService(CommandSupport.class, service).orElseThrow(() -> new UnsupportedOperationException(service + " not found"));
    }

    protected final Flux<AiModel> getModels(Collection<String> id) {
        return ((Flux)this.modelManager.execute((Command)QueryListCommand.of(AiModelInfo.class).dsl(query -> {
            Query cfr_ignored_0 = (Query)query.in("id", id);
        }))).map(x$0 -> new AiModelImpl((AiModelInfo)x$0));
    }

    protected Mono<Map<String, List<PropertyMetadata>>> getAiOutputPropertyMetadata(GetAiOutputMetadataCommand cmd) {
        List idList = cmd.getIdList(String::valueOf);
        return Flux.fromIterable((Iterable)idList).distinct().filter(command -> {
            CommandHandler handler = (CommandHandler)this.handlers.get(command);
            return handler instanceof AICommandHandler;
        }).collectMap(Function.identity(), command -> {
            AICommandHandler aiHandler = (AICommandHandler)this.handlers.get(command);
            return new ArrayList(aiHandler.getAiOutputPropertyMetadata(cmd.getType()));
        });
    }

    private class AiModelImpl
    implements AiModel {
        private final AiModelInfo info;

        @Override
        public String getId() {
            return this.info.getId();
        }

        @Override
        public String getName() {
            return this.info.getName();
        }

        @Override
        public String getProvider() {
            return this.info.getProvider() == null ? null : (String)this.info.getProvider().getValue();
        }

        @Override
        public String getTarget() {
            return this.info.getTarget() == null ? null : (String)this.info.getTarget().getValue();
        }

        @Override
        public Mono<InputStream> readContent() {
            return ((Mono)((Flux)AiPlugin.this.fileService.execute((Command)new DownloadFileCommand().setUrl(this.info.getFileUrl()))).map(ConverterUtils::convertDataBuffer).as(DataBufferUtils::join)).map(dataBuffer -> dataBuffer.asInputStream(true));
        }

        @Override
        public Mono<Void> writeContentTo(OutputStream output) {
            return DataBufferUtils.write((Publisher)((Flux)AiPlugin.this.fileService.execute((Command)new DownloadFileCommand().setUrl(this.info.getFileUrl()))).map(ConverterUtils::convertDataBuffer), (OutputStream)output).doOnNext(DataBufferUtils::release).then();
        }

        @Override
        public Map<String, Object> getOthers() {
            return this.info.getOthers();
        }

        public AiModelImpl(AiModelInfo info) {
            this.info = info;
        }
    }
}

