/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.utils.RecyclerUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.PathMatcher;

public class TopicUtils {
    public static final char PATH_SPLITTER = '/';
    public static final String ANY = "*";
    public static final String ANY_ALL = "**";
    private static final PathMatcher pathMatcher = new AntPathMatcher();
    private static final Map<String, String[]> splitCache = new ConcurrentReferenceHashMap(20480, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    private static final FastThreadLocal<List<String>> SHARE_SPLIT = new FastThreadLocal<List<String>>(){

        protected List<String> initialValue() {
            return new ArrayList<String>(8);
        }
    };
    private static final FastThreadLocal<StringBuilder> SHARE_BUILDER = new FastThreadLocal<StringBuilder>(){

        protected StringBuilder initialValue() {
            return new StringBuilder(8);
        }
    };

    public static String convertToMqttTopic(String url) {
        CharSequence[] arr = TopicUtils.split(url);
        for (int i = 0; i < arr.length; ++i) {
            String str = arr[i];
            if (str.startsWith("{") && str.endsWith("}")) {
                if (str.charAt(1) == '#') {
                    arr[i] = "#";
                    continue;
                }
                arr[i] = "+";
                continue;
            }
            if (str.equals(ANY_ALL)) {
                arr[i] = "#";
                continue;
            }
            if (!str.equals(ANY)) continue;
            arr[i] = "+";
        }
        return String.join((CharSequence)"/", arr);
    }

    public static boolean match(String pattern, String topic) {
        if (pattern.equals(topic)) {
            return true;
        }
        if (!(pattern.contains(ANY) || pattern.contains("#") || pattern.contains("+") || pattern.contains("{"))) {
            return false;
        }
        return pathMatcher.match(pattern.replace("#", ANY_ALL).replace("+", ANY), topic);
    }

    public static Map<String, String> getPathVariables(String template, String topic) {
        try {
            return pathMatcher.extractUriTemplateVariables(template, topic);
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public static String[] split(String topic) {
        return TopicUtils.split(topic, false);
    }

    public static String[] split(String topic, boolean cache, boolean intern) {
        if (!cache) {
            return TopicUtils.doSplit(topic);
        }
        if (intern) {
            return splitCache.computeIfAbsent(topic, t -> TopicUtils.split(t, '/', (i, p) -> {
                if (Objects.equals(p, ANY)) {
                    return ANY;
                }
                if (Objects.equals(p, ANY_ALL)) {
                    return ANY_ALL;
                }
                return RecyclerUtils.intern(p);
            }));
        }
        return splitCache.computeIfAbsent(topic, TopicUtils::doSplit);
    }

    private static String[] doSplit(String topic) {
        return TopicUtils.split(topic, '/');
    }

    public static String[] split(String topic, char pattern) {
        return TopicUtils.split(topic, pattern, (index, part) -> part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] split(String topic, char pattern, BiFunction<Integer, String, String> converter) {
        List list = (List)SHARE_SPLIT.get();
        StringBuilder builder = (StringBuilder)SHARE_BUILDER.get();
        try {
            int len = topic.length();
            int total = 0;
            for (int i = 0; i < len; ++i) {
                char ch = topic.charAt(i);
                if (ch == pattern) {
                    list.add(converter.apply(total, builder.toString()));
                    builder.setLength(0);
                    ++total;
                    continue;
                }
                builder.append(ch);
            }
            if (builder.length() > 0) {
                list.add(converter.apply(total, builder.toString()));
                ++total;
            }
            String[] stringArray = list.toArray(new String[total]);
            return stringArray;
        }
        finally {
            builder.setLength(0);
            list.clear();
        }
    }

    public static String[] split(String topic, boolean cache) {
        return TopicUtils.split(topic, cache, true);
    }

    private static boolean matchStrings(String str, String pattern) {
        return str.equals(pattern) || ANY.equals(pattern) || ANY.equals(str);
    }

    private static boolean matchStrings(CharSequence str, CharSequence pattern) {
        return pattern.equals(str) || pattern.equals(ANY) || str.equals(ANY);
    }

    public static boolean match(SeparatedCharSequence pattern, SeparatedCharSequence topicParts) {
        CharSequence pattDir;
        int pathIdxStart;
        int patternSize = pattern.size();
        int partsSize = topicParts.size();
        if (patternSize == 0 && partsSize == 0) {
            return true;
        }
        int pattIdxStart = 0;
        int pattIdxEnd = patternSize - 1;
        int pathIdxEnd = partsSize - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(pattDir = pattern.get(pattIdxStart)).equals(ANY_ALL); ++pattIdxStart, ++pathIdxStart) {
            if (TopicUtils.matchStrings(pattDir, topicParts.get(pathIdxStart))) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern.get(patternSize - 1).equals("/") == topicParts.get(partsSize - 1).equals("/");
            }
            if (pattIdxStart == pattIdxEnd && pattern.get(pattIdxStart).equals(ANY) && topicParts.get(partsSize - 1).equals("/")) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattern.get(i).equals(ANY_ALL)) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (topicParts.get(pattIdxStart).equals(ANY_ALL)) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(pattDir = pattern.get(pattIdxEnd)).equals(ANY_ALL)) {
            if (!TopicUtils.matchStrings(pattDir, topicParts.get(pathIdxEnd))) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattern.get(i).equals(ANY_ALL)) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!pattern.get(i).equals(ANY_ALL)) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    CharSequence subStr;
                    CharSequence subPat = pattern.get(pattIdxStart + j + 1);
                    if (!TopicUtils.matchStrings(subPat, subStr = topicParts.get(pathIdxStart + i + j))) continue block6;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (pattern.get(i).equals(ANY_ALL)) continue;
            return false;
        }
        return true;
    }

    public static boolean match(String[] pattern, String[] topicParts) {
        String pattDir;
        int pathIdxStart;
        if (pattern.length == 0 && topicParts.length == 0) {
            return true;
        }
        int pattIdxStart = 0;
        int pattIdxEnd = pattern.length - 1;
        int pathIdxEnd = topicParts.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !ANY_ALL.equals(pattDir = pattern[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (TopicUtils.matchStrings(pattDir, topicParts[pathIdxStart])) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern[pattern.length - 1].equals("/") == topicParts[topicParts.length - 1].equals("/");
            }
            if (pattIdxStart == pattIdxEnd && pattern[pattIdxStart].equals(ANY) && topicParts[topicParts.length - 1].equals("/")) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattern[i].equals(ANY_ALL)) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (ANY_ALL.equals(topicParts[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(pattDir = pattern[pattIdxEnd]).equals(ANY_ALL)) {
            if (!TopicUtils.matchStrings(pattDir, topicParts[pathIdxEnd])) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattern[i].equals(ANY_ALL)) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!pattern[i].equals(ANY_ALL)) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = pattern[pattIdxStart + j + 1];
                    String subStr = topicParts[pathIdxStart + i + j];
                    if (!TopicUtils.matchStrings(subPat, subStr)) continue block6;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (pattern[i].equals(ANY_ALL)) continue;
            return false;
        }
        return true;
    }

    public static List<String> expand(String topic) {
        if (!topic.contains(",") && !topic.contains("{")) {
            return Collections.singletonList(topic);
        }
        if (topic.startsWith("/")) {
            topic = topic.substring(1);
        }
        String[] parts = topic.split("/", 2);
        String first = parts[0];
        ArrayList<String> expands = new ArrayList<String>();
        if (parts.length == 1) {
            for (String split : first.split(",")) {
                if (split.startsWith("{") && split.endsWith("}")) {
                    split = ANY;
                }
                expands.add("/" + split);
            }
            return expands;
        }
        List<String> nextTopics = TopicUtils.expand(parts[1]);
        for (String split : first.split(",")) {
            if (split.startsWith("{") && split.endsWith("}")) {
                split = ANY;
            }
            for (String nextTopic : nextTopics) {
                StringJoiner joiner = new StringJoiner("");
                joiner.add("/");
                joiner.add(split);
                if (!nextTopic.startsWith("/")) {
                    joiner.add("/");
                }
                joiner.add(nextTopic);
                expands.add(joiner.toString());
            }
        }
        return expands;
    }
}

