/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ParallelIntervalHelper {
    private final long interval;
    private final ConcurrentMap<String, Info> times = new ConcurrentHashMap<String, Info>();

    public static ParallelIntervalHelper create(Duration interval) {
        return new ParallelIntervalHelper(interval.toMillis());
    }

    public long next(@Nonnull String key) {
        Info last = this.times.compute(key, (k, old) -> {
            long now = System.currentTimeMillis();
            if (old == null) {
                return new Info(0L, now);
            }
            old.next(now, this.interval);
            return old;
        });
        return last.interval;
    }

    public long current(@Nonnull String key) {
        Info info = (Info)this.times.get(key);
        if (info == null) {
            return 0L;
        }
        return info.current(System.currentTimeMillis(), this.interval);
    }

    public <T> Flux<T> delay(@Nonnull String key, @Nonnull Flux<T> source) {
        return source.flatMap(e -> this.delay(key, Mono.just((Object)e), Mono::delayElement));
    }

    public <T> Mono<T> delay(@Nonnull String key, @Nonnull Mono<T> source) {
        return this.delay(key, source, Mono::delayElement);
    }

    public Mono<Void> delay(@Nonnull String key) {
        return this.delay(key, Mono.just((Object)1), Mono::delayElement).then();
    }

    public <S> S delay(@Nonnull String key, S source, BiFunction<S, Duration, S> mapper) {
        long delay = this.next(key);
        if (delay > 0L) {
            return mapper.apply(source, Duration.ofMillis(delay));
        }
        return source;
    }

    private ParallelIntervalHelper(long interval) {
        this.interval = interval;
    }

    private static class Info {
        private long interval;
        private long lastTime;

        public long current(long now, long interval) {
            if (now - this.lastTime > interval) {
                return 0L;
            }
            return this.interval;
        }

        public synchronized void next(long now, long interval) {
            long requestInterval = now - this.lastTime;
            this.interval = Math.max(0L, this.interval - requestInterval + interval);
            this.lastTime = now;
        }

        public Info(long interval, long lastTime) {
            this.interval = interval;
            this.lastTime = lastTime;
        }
    }
}

