/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class NumberUtils {
    public static double convertEffectiveScale(double origin, int scale) {
        return NumberUtils.convertEffectiveScaleNumber(origin, scale).doubleValue();
    }

    public static String toEffectiveScaleString(double origin, int scale) {
        Number num = NumberUtils.convertEffectiveScaleNumber(origin, scale);
        if (num instanceof BigDecimal) {
            return ((BigDecimal)num).toPlainString();
        }
        return new BigDecimal(num.toString()).setScale(scale, RoundingMode.HALF_UP).toPlainString();
    }

    public static Number convertEffectiveScaleNumber(double origin, int scale) {
        if (origin == 0.0) {
            return origin;
        }
        double integerPart = origin > 0.0 ? Math.floor(origin) : Math.ceil(origin);
        double decimalPart = origin - integerPart;
        if (decimalPart == 0.0) {
            return origin;
        }
        if (integerPart != 0.0) {
            return BigDecimal.valueOf(origin).setScale(scale, RoundingMode.HALF_UP);
        }
        int n = scale;
        double temp = decimalPart;
        if (temp < 0.0) {
            while (temp > -1.0) {
                temp *= 10.0;
                ++n;
            }
        } else {
            while (temp < 1.0) {
                temp *= 10.0;
                ++n;
            }
        }
        return new BigDecimal(decimalPart).setScale(n - 1, RoundingMode.HALF_UP);
    }

    public static long fixLength(long value, int length) {
        int len = (int)Math.log10(value) + 1;
        int digDiff = length - len;
        if (digDiff > 0) {
            value *= (long)Math.pow(10.0, digDiff);
        } else if (digDiff < 0) {
            value /= (long)Math.pow(10.0, Math.abs(digDiff));
        }
        return value;
    }

    public static int numberOfPlace(Number number) {
        if (NumberUtils.isIntNumber(number)) {
            return 0;
        }
        BigDecimal decimal = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(String.valueOf(number));
        String str = decimal.stripTrailingZeros().toPlainString();
        int index = str.indexOf(".");
        return index < 0 ? 0 : str.length() - index - 1;
    }

    public static boolean isIntNumber(Number number) {
        return number instanceof Integer || number instanceof Long || number instanceof Byte || number instanceof Short || number instanceof BigInteger;
    }
}

