/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import com.google.common.collect.Sets;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.ezorm.core.CastUtil;
import org.hswebframework.web.dict.EnumDict;
import org.jetlinks.core.annotation.Attr;
import org.jetlinks.core.annotation.Expands;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.Metadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.DoubleType;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.FloatType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.LongType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.core.things.ThingsConfigKeys;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import reactor.util.function.Tuples;

public class MetadataUtils {
    public static String resolveI18nMessage(Locale locale, Metadata metadata, String key, String defaultMsg) {
        return MetadataUtils.resolveI18nMessage(locale, metadata.getExpand(ThingsConfigKeys.i18nMessages).orElse(null), key, defaultMsg);
    }

    public static String resolveI18nMessage(Locale locale, Map<String, Map<String, String>> source, String key, String defaultMsg) {
        if (MapUtils.isEmpty(source)) {
            return defaultMsg;
        }
        Map<String, String> i18n = source.get(key);
        if (MapUtils.isEmpty(i18n)) {
            return defaultMsg;
        }
        String msg = i18n.get(locale.toString());
        if (msg != null) {
            return msg;
        }
        msg = i18n.get(locale.getLanguage());
        if (msg != null) {
            return msg;
        }
        return defaultMsg;
    }

    public static PropertyMetadata parseProperty(Field field, ResolvableType type) {
        return MetadataParser.withField(field, type);
    }

    public static DataType parseType(ResolvableType type) {
        return MetadataParser.withType(type);
    }

    public static Map<String, Object> parseExpands(Annotation ... annotations) {
        HashMap<String, Object> expands = new HashMap<String, Object>();
        MetadataParser.parseExpands(annotations, true, expands);
        return expands;
    }

    public static Map<String, Object> parseExpands(AnnotatedElement element) {
        HashMap<String, Object> expands = new HashMap<String, Object>();
        MetadataParser.parseExpands(element, true, expands);
        return expands;
    }

    static class MetadataParser {
        static final Set<String> jsr303Packages = Sets.newHashSet((Object[])new String[]{"javax.validation.constraints", "jakarta.validation.constraints", "org.hibernate.validator.constraints"});
        Set<Object> distinct = new HashSet<Object>();

        MetadataParser() {
        }

        public static PropertyMetadata withField(Field field, ResolvableType type) {
            return new MetadataParser().withField0(field.getDeclaringClass(), field, type);
        }

        public static DataType withType(ResolvableType type) {
            return new MetadataParser().withType0(null, type);
        }

        static void parseJsr303(Annotation[] annotation, Map<String, Object> container) {
            ArrayList validators = new ArrayList();
            for (Annotation ann : annotation) {
                if (!jsr303Packages.contains(ann.annotationType().getPackage().getName())) continue;
                HashMap<String, Object> validator = new HashMap<String, Object>((Map<String, Object>)AnnotationUtils.getAnnotationAttributes((Annotation)ann, (boolean)true, (boolean)true));
                validator.put("type", ann.annotationType().getSimpleName());
                validator.compute("groups", (ignore, groups) -> {
                    if (groups instanceof String[]) {
                        String[] lst = (String[])groups;
                        if (lst.length == 0) {
                            return null;
                        }
                        for (int i = 0; i < lst.length; ++i) {
                            if (!lst[i].contains(".")) continue;
                            lst[i] = lst[i].substring(lst[i].lastIndexOf(46) + 1);
                        }
                        return lst;
                    }
                    return null;
                });
                validator.remove("payload");
                validator.remove("message");
                validators.add(validator);
            }
            if (!validators.isEmpty()) {
                container.putIfAbsent("validators", validators);
            }
        }

        static void parseAttr(AnnotatedElement element, Map<String, Object> container) {
            Set attrs = AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)element, Attr.class);
            for (Attr attr : attrs) {
                container.putIfAbsent(attr.key(), attr.value());
            }
        }

        static void parseExpands(Annotation[] annotation, boolean includeName, Map<String, Object> container) {
            for (Annotation ann : annotation) {
                HashSet<Expands> expandsSet = new HashSet<Expands>();
                if (ann instanceof Expands) {
                    expandsSet.add((Expands)ann);
                } else if (ann instanceof Expands.List) {
                    expandsSet.addAll(Arrays.asList(((Expands.List)ann).value()));
                } else {
                    expandsSet.addAll(AnnotatedElementUtils.findMergedRepeatableAnnotations(ann.annotationType(), Expands.class));
                    Expands e = (Expands)AnnotatedElementUtils.findMergedAnnotation(ann.annotationType(), Expands.class);
                    if (e == null) continue;
                    expandsSet.add(e);
                }
                if (!CollectionUtils.isNotEmpty(expandsSet)) continue;
                for (Expands exp : expandsSet) {
                    Map<String, Object> c = container;
                    if (includeName && StringUtils.hasText((String)exp.key())) {
                        c = new HashMap<String, Object>();
                        container.put(exp.key(), c);
                    }
                    if (ann.annotationType() != Expands.class && ann.annotationType() != Expands.List.class) {
                        AnnotationAttributes annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)ann, (boolean)false, (boolean)true);
                        for (Map.Entry entry : annotationAttributes.entrySet()) {
                            if (entry.getValue() instanceof Class) {
                                DataType parseType = MetadataUtils.parseType(ResolvableType.forClass((Class)((Class)CastUtil.cast(entry.getValue()))));
                                List<PropertyMetadata> properties = ((ObjectType)parseType).getProperties();
                                c.putIfAbsent((String)entry.getKey(), properties);
                                continue;
                            }
                            c.putIfAbsent((String)entry.getKey(), entry.getValue());
                        }
                        MetadataParser.parseExpands(ann.annotationType(), false, c);
                        MetadataParser.parseAttr(ann.annotationType(), c);
                    }
                    for (Attr attr : exp.value()) {
                        c.putIfAbsent(attr.key(), attr.value());
                    }
                }
            }
            MetadataParser.parseJsr303(annotation, container);
        }

        static void parseExpands(AnnotatedElement element, boolean includeName, Map<String, Object> container) {
            MetadataParser.parseExpands(element.getAnnotations(), includeName, container);
        }

        private PropertyMetadata withField0(Class<?> owner, Field field, ResolvableType type) {
            Schema schema = this.getSchema(owner, field);
            String id = field.getName();
            SimplePropertyMetadata metadata = new SimplePropertyMetadata();
            metadata.setId(id);
            metadata.setName(id);
            metadata.setValueType(this.withType0(field, type));
            HashMap<String, Object> expands = new HashMap<String, Object>();
            Method method = this.getReadMethod(owner, field);
            if (method != null) {
                MetadataParser.parseExpands(method, true, expands);
            }
            MetadataParser.parseExpands(field, true, expands);
            metadata.setExpands(expands);
            if (null != schema) {
                if (StringUtils.hasText((String)schema.description())) {
                    metadata.setDescription(schema.description());
                    metadata.setName(schema.description());
                }
                if (StringUtils.hasText((String)schema.title())) {
                    metadata.setName(schema.title());
                }
            }
            return metadata;
        }

        private DataType withType0(Object owner, ResolvableType type) {
            Class clazz = type.toClass();
            if (clazz == Object.class) {
                return null;
            }
            if (Publisher.class.isAssignableFrom(clazz)) {
                clazz = type.getGeneric(new int[]{0}).toClass();
            }
            if (List.class.isAssignableFrom(clazz)) {
                ArrayType arrayType = new ArrayType();
                arrayType.setElementType(this.withType0(owner, type.getGeneric(new int[]{0})));
                return arrayType;
            }
            if (clazz.isArray()) {
                ArrayType arrayType = new ArrayType();
                arrayType.setElementType(this.withType0(owner, ResolvableType.forType(clazz.getComponentType())));
                return arrayType;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return new ObjectType();
            }
            if (clazz == String.class || clazz == Character.class) {
                return new StringType();
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return new IntType().max((byte)127);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return new IntType().max((short)Short.MAX_VALUE).min(0);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return new IntType();
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return new LongType();
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return new FloatType();
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return new DoubleType();
            }
            if (clazz == Date.class || clazz == LocalDateTime.class) {
                return new DateTimeType();
            }
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return new BooleanType();
            }
            if (clazz.isEnum()) {
                EnumType enumType = new EnumType();
                for (Object constant : clazz.getEnumConstants()) {
                    Object dict;
                    if (constant instanceof EnumDict) {
                        dict = (EnumDict)constant;
                        enumType.addElement(EnumType.Element.of(String.valueOf(dict.getValue()), dict.getText()));
                        continue;
                    }
                    dict = (Enum)constant;
                    enumType.addElement(EnumType.Element.of(((Enum)dict).name(), ((Enum)dict).name()));
                }
                return enumType;
            }
            ObjectType objectType = new ObjectType();
            Class fClass = clazz;
            ReflectionUtils.doWithFields((Class)fClass, field -> {
                if (owner != null && !this.distinct.add(Tuples.of((Object)owner, (Object)field))) {
                    objectType.addPropertyMetadata(this.withField0(fClass, field, ResolvableType.forClass(Map.class)));
                    return;
                }
                Schema schema = this.getSchema(fClass, field);
                if (schema != null && !schema.hidden()) {
                    objectType.addPropertyMetadata(this.withField0(fClass, field, ResolvableType.forField((Field)field, (ResolvableType)type)));
                }
            });
            return objectType;
        }

        private Method getReadMethod(Class<?> owner, Field field) {
            String name = field.getName();
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(name, owner);
                return descriptor.getReadMethod();
            }
            catch (IntrospectionException introspectionException) {
                return null;
            }
        }

        private Schema getSchema(Class<?> owner, Field field) {
            Schema schema;
            Method readMethod = this.getReadMethod(owner, field);
            if (readMethod != null && (schema = (Schema)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)readMethod, Schema.class)) != null) {
                return schema;
            }
            return (Schema)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, Schema.class);
        }
    }
}

