/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

public class BytesUtils {
    public static int leToInt(byte[] src, int offset, int len) {
        int n = 0;
        len = Math.min(len, 4);
        for (int i = 0; i < len; ++i) {
            int left = i * 8;
            n += (src[i + offset] & 0xFF) << left;
        }
        return n;
    }

    public static int leToInt(byte[] src) {
        return BytesUtils.leToInt(src, 0, src.length);
    }

    public static long leToLong(byte[] src, int offset, int len) {
        long n = 0L;
        len = Math.min(Math.min(len, src.length), 8);
        for (int i = 0; i < len; ++i) {
            int left = i * 8;
            n += (long)(src[i + offset] & 0xFF) << left;
        }
        return n;
    }

    public static long leToLong(byte[] src) {
        return BytesUtils.highBytesToLong(src, 0, src.length);
    }

    @Deprecated
    public static int highBytesToInt(byte[] src, int offset, int len) {
        return BytesUtils.leToInt(src, offset, len);
    }

    @Deprecated
    public static long highBytesToLong(byte[] src, int offset, int len) {
        return BytesUtils.leToLong(src, offset, len);
    }

    @Deprecated
    public static int highBytesToInt(byte[] src) {
        return BytesUtils.highBytesToInt(src, 0, src.length);
    }

    @Deprecated
    public static long highBytesToLong(byte[] src) {
        return BytesUtils.highBytesToLong(src, 0, src.length);
    }

    public static float leToFloat(byte[] src, int offset, int len) {
        return Float.intBitsToFloat(BytesUtils.leToInt(src, offset, len));
    }

    public static float leToFloat(byte[] src) {
        return BytesUtils.leToFloat(src, 0, src.length);
    }

    public static double leToDouble(byte[] src, int offset, int len) {
        return Double.longBitsToDouble(BytesUtils.leToLong(src, offset, len));
    }

    public static double leToDouble(byte[] src) {
        return BytesUtils.leToDouble(src, 0, src.length);
    }

    @Deprecated
    public static float highBytesToFloat(byte[] src, int offset, int len) {
        return BytesUtils.leToFloat(src, offset, len);
    }

    @Deprecated
    public static double highBytesToDouble(byte[] src, int offset, int len) {
        return Double.longBitsToDouble(BytesUtils.highBytesToLong(src, offset, len));
    }

    @Deprecated
    public static float highBytesToFloat(byte[] src) {
        return BytesUtils.leToFloat(src, 0, src.length);
    }

    @Deprecated
    public static double highBytesToDouble(byte[] src) {
        return BytesUtils.highBytesToDouble(src, 0, src.length);
    }

    public static int beToInt(byte[] src, int offset, int len) {
        int n = 0;
        len = Math.min(Math.min(len, src.length), 4);
        for (int i = 0; i < len; ++i) {
            int left = i * 8;
            n += (src[offset + len - i - 1] & 0xFF) << left;
        }
        return n;
    }

    @Deprecated
    public static int lowBytesToInt(byte[] src, int offset, int len) {
        return BytesUtils.beToInt(src, offset, len);
    }

    public static long beToLong(byte[] src, int offset, int len) {
        long n = 0L;
        len = Math.min(Math.min(len, src.length), 8);
        for (int i = 0; i < len; ++i) {
            int left = i * 8;
            n += (long)(src[offset + len - i - 1] & 0xFF) << left;
        }
        return n;
    }

    public static float beToFloat(byte[] src, int offset, int len) {
        return Float.intBitsToFloat(BytesUtils.beToInt(src, offset, len));
    }

    public static double beToDouble(byte[] src, int offset, int len) {
        return Double.longBitsToDouble(BytesUtils.beToLong(src, offset, len));
    }

    @Deprecated
    public static long lowBytesToLong(byte[] src, int offset, int len) {
        return BytesUtils.beToLong(src, offset, len);
    }

    @Deprecated
    public static float lowBytesToFloat(byte[] src, int offset, int len) {
        return Float.intBitsToFloat(BytesUtils.lowBytesToInt(src, offset, len));
    }

    @Deprecated
    public static double lowBytesToDouble(byte[] src, int offset, int len) {
        return BytesUtils.beToDouble(src, offset, len);
    }

    public static int beToInt(byte[] src) {
        return BytesUtils.beToInt(src, 0, src.length);
    }

    @Deprecated
    public static int lowBytesToInt(byte[] src) {
        return BytesUtils.lowBytesToInt(src, 0, src.length);
    }

    public static long beToLong(byte[] src) {
        return BytesUtils.beToLong(src, 0, src.length);
    }

    @Deprecated
    public static long lowBytesToLong(byte[] src) {
        return BytesUtils.lowBytesToLong(src, 0, src.length);
    }

    public static float beToFloat(byte[] src) {
        return BytesUtils.beToFloat(src, 0, src.length);
    }

    @Deprecated
    public static float lowBytesToFloat(byte[] src) {
        return BytesUtils.lowBytesToFloat(src, 0, src.length);
    }

    public static double beToDouble(byte[] src) {
        return BytesUtils.beToDouble(src, 0, src.length);
    }

    @Deprecated
    public static double lowBytesToDouble(byte[] src) {
        return BytesUtils.lowBytesToDouble(src, 0, src.length);
    }

    public static byte[] numberToLe(byte[] target, Number number, int offset, int len) {
        long src = number.longValue();
        for (int i = 0; i < len; ++i) {
            target[offset + i] = (byte)(src >> i * 8 & 0xFFL);
        }
        return target;
    }

    @Deprecated
    public static byte[] toHighBytes(byte[] target, long src, int offset, int len) {
        return BytesUtils.numberToBe(target, src, offset, len);
    }

    public static byte[] intToLe(byte[] target, int number, int offset) {
        return BytesUtils.numberToLe(target, number, offset, 4);
    }

    public static byte[] intToLe(int src) {
        return BytesUtils.intToLe(new byte[4], src, 0);
    }

    public static byte[] shortToLe(byte[] target, short number, int offset) {
        return BytesUtils.numberToLe(target, number, offset, 2);
    }

    public static byte[] shortToLe(short src) {
        return BytesUtils.shortToLe(new byte[2], src, 0);
    }

    public static byte[] longToLe(byte[] target, long number, int offset) {
        return BytesUtils.numberToLe(target, number, offset, 8);
    }

    public static byte[] longToLe(long src) {
        return BytesUtils.longToLe(new byte[8], src, 0);
    }

    public static byte[] floatToLe(byte[] target, float number, int offset) {
        return BytesUtils.intToBe(target, Float.floatToIntBits(number), offset);
    }

    public static byte[] floatToLe(float src) {
        return BytesUtils.intToLe(Float.floatToIntBits(src));
    }

    public static byte[] doubleToLe(byte[] target, double number, int offset) {
        return BytesUtils.longToLe(target, Double.doubleToLongBits(number), offset);
    }

    public static byte[] doubleToLe(double src) {
        return BytesUtils.longToLe(Double.doubleToLongBits(src));
    }

    @Deprecated
    public static byte[] toHighBytes(int src) {
        return BytesUtils.intToLe(src);
    }

    @Deprecated
    public static byte[] toHighBytes(long src) {
        return BytesUtils.longToLe(src);
    }

    @Deprecated
    public static byte[] toHighBytes(double src) {
        return BytesUtils.doubleToLe(src);
    }

    @Deprecated
    public static byte[] toHighBytes(float src) {
        return BytesUtils.intToLe(Float.floatToIntBits(src));
    }

    public static byte[] numberToBe(byte[] target, Number number, int offset, int len) {
        long src = number.longValue();
        for (int i = 0; i < len; ++i) {
            target[offset + len - i - 1] = (byte)(src >> i * 8 & 0xFFL);
        }
        return target;
    }

    @Deprecated
    public static byte[] toLowBytes(byte[] target, long src, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            target[offset + len - i - 1] = (byte)(src >> i * 8 & 0xFFL);
        }
        return target;
    }

    public static byte[] intToBe(byte[] target, int number, int offset) {
        return BytesUtils.numberToBe(target, number, offset, 4);
    }

    public static byte[] intToBe(int src) {
        return BytesUtils.intToBe(new byte[4], src, 0);
    }

    public static byte[] shortToBe(byte[] target, short number, int offset) {
        return BytesUtils.numberToBe(target, number, offset, 2);
    }

    public static byte[] shortToBe(short src) {
        return BytesUtils.shortToBe(new byte[2], src, 0);
    }

    public static byte[] longToBe(byte[] target, long number, int offset) {
        return BytesUtils.numberToBe(target, number, offset, 8);
    }

    public static byte[] longToBe(long src) {
        return BytesUtils.longToBe(new byte[8], src, 0);
    }

    public static byte[] floatToBe(byte[] target, float number, int offset) {
        return BytesUtils.intToBe(target, Float.floatToIntBits(number), offset);
    }

    public static byte[] floatToBe(float src) {
        return BytesUtils.intToBe(Float.floatToIntBits(src));
    }

    public static byte[] doubleToBe(byte[] target, double number, int offset) {
        return BytesUtils.longToBe(target, Double.doubleToLongBits(number), offset);
    }

    public static byte[] doubleToBe(double src) {
        return BytesUtils.longToBe(Double.doubleToLongBits(src));
    }

    public static byte[] reverse(byte[] data, int offset, int length) {
        int len = Math.min(data.length - 1, length);
        for (int i = 0; i < length / 2; ++i) {
            int idx = i + offset;
            int rev = len - i;
            byte temp = data[idx];
            data[idx] = data[rev];
            data[rev] = temp;
        }
        return data;
    }

    public static byte[] reverse(byte[] data) {
        return BytesUtils.reverse(data, 0, data.length);
    }

    @Deprecated
    public static byte[] toLowBytes(int src) {
        return BytesUtils.toLowBytes(new byte[4], src, 0, 4);
    }

    @Deprecated
    public static byte[] toLowBytes(long src) {
        return BytesUtils.toLowBytes(new byte[8], src, 0, 8);
    }

    @Deprecated
    public static byte[] toLowBytes(double src) {
        return BytesUtils.toLowBytes(Double.doubleToLongBits(src));
    }

    @Deprecated
    public static byte[] toLowBytes(float src) {
        return BytesUtils.toLowBytes(Float.floatToIntBits(src));
    }
}

