/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jetlinks.core.Lazy;
import org.jetlinks.core.LazyConverter;
import org.jetlinks.core.trace.ErrorAttributes;
import org.jetlinks.core.trace.ReactiveSpan;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.SignalType;
import reactor.function.Consumer3;
import reactor.util.context.ContextView;

class TraceSubscriber<T>
extends BaseSubscriber<T>
implements ReactiveSpan {
    static final AttributeKey<Long> ATTR_NEXT_COUNT = AttributeKey.longKey((String)"flux-next-count");
    static final AtomicLongFieldUpdater<TraceSubscriber> NEXT_COUNT = AtomicLongFieldUpdater.newUpdater(TraceSubscriber.class, "nextCount");
    private final CoreSubscriber<? super T> actual;
    private final Span span;
    private final Consumer3<ContextView, ReactiveSpan, T> onNext;
    private final Consumer3<ContextView, ReactiveSpan, Long> onComplete;
    private final BiConsumer<ContextView, Throwable> onError;
    private volatile long nextCount;
    private volatile boolean stateSet;
    private final long startWithNanos;
    private final Instant startWith;
    private final reactor.util.context.Context context;

    public TraceSubscriber(Instant startWith, CoreSubscriber<? super T> actual, Span span, Consumer3<ContextView, ReactiveSpan, T> onNext, Consumer3<ContextView, ReactiveSpan, Long> onComplete, BiConsumer<ContextView, Throwable> onError, Context ctx) {
        this.actual = actual;
        this.span = span;
        this.onNext = onNext;
        this.onComplete = onComplete;
        this.onError = onError;
        this.startWithNanos = System.nanoTime();
        this.startWith = startWith;
        this.context = reactor.util.context.Context.of((ContextView)actual.currentContext()).put(SpanContext.class, (Object)span.getSpanContext()).put(Context.class, (Object)span.storeInContext(ctx));
    }

    protected void hookOnSubscribe(@Nonnull Subscription subscription) {
        try (Scope ignored = this.span.makeCurrent();){
            this.actual.onSubscribe((Subscription)this);
        }
    }

    protected void hookOnError(@Nonnull Throwable throwable) {
        this.span.setStatus(StatusCode.ERROR);
        if (this.onError != null) {
            this.onError.accept((ContextView)this.context, throwable);
        } else {
            this.span.addEvent("exception", (Attributes)new ErrorAttributes(throwable), this.startWith.plusNanos(System.nanoTime() - this.startWithNanos));
        }
        try (Scope ignored = this.span.makeCurrent();){
            this.actual.onError(throwable);
        }
    }

    @Nonnull
    public reactor.util.context.Context currentContext() {
        return this.context;
    }

    protected void hookFinally(@Nonnull SignalType type) {
        try (Scope ignored = ((Context)this.context.get(Context.class)).makeCurrent();){
            this.span.end(this.startWith.plusNanos(System.nanoTime() - this.startWithNanos));
        }
    }

    protected void hookOnCancel() {
        this.span.setAttribute(ATTR_NEXT_COUNT, (Object)this.nextCount);
        if (this.nextCount > 0L) {
            this.span.setStatus(StatusCode.OK, "cancel");
        } else if (!this.stateSet) {
            this.span.setStatus(StatusCode.ERROR, "cancel");
        }
    }

    protected void hookOnNext(@Nonnull T value) {
        if (null != this.onNext) {
            this.onNext.accept((Object)this.context, (Object)this, value);
        }
        this.stateSet = true;
        NEXT_COUNT.incrementAndGet(this);
        try (Scope ignored = this.span.makeCurrent();){
            this.actual.onNext(value);
        }
    }

    protected void hookOnComplete() {
        if (this.onComplete != null) {
            this.onComplete.accept((Object)this.context, (Object)this, (Object)this.nextCount);
        }
        this.span.setAttribute(ATTR_NEXT_COUNT, (Object)this.nextCount);
        if (!this.stateSet) {
            this.span.setStatus(StatusCode.OK);
        }
        this.stateSet = true;
        try (Scope ignored = this.span.makeCurrent();){
            this.actual.onComplete();
        }
    }

    @Override
    public <T> ReactiveSpan setAttributeLazy(AttributeKey<T> key, Supplier<T> lazyValue) {
        this.span.setAttribute(key, lazyValue instanceof Lazy ? lazyValue : Lazy.of(lazyValue));
        return this;
    }

    @Override
    public <V, T> ReactiveSpan setAttributeLazy(AttributeKey<T> key, V value, Function<V, T> lazyValue) {
        this.span.setAttribute(key, lazyValue instanceof LazyConverter ? lazyValue : LazyConverter.of(value, lazyValue));
        return this;
    }

    @Override
    public ReactiveSpan setAttribute(@Nonnull String key, double value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpan setAttribute(@Nonnull String key, long value) {
        this.span.setAttribute(key, value);
        return this;
    }

    public <R> ReactiveSpan setAttribute(@Nonnull AttributeKey<R> key, @Nonnull R value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpan setAttribute(@Nonnull String key, @Nonnull String value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpan setAttribute(@Nonnull String key, boolean value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpan setAttribute(@Nonnull AttributeKey<Long> key, int value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpan setStatus(@Nonnull StatusCode statusCode) {
        this.span.setStatus(statusCode);
        return this;
    }

    public Span setAllAttributes(@Nonnull Attributes attributes) {
        this.span.setAllAttributes(attributes);
        return this;
    }

    public ReactiveSpan addEvent(@Nonnull String name, @Nonnull Attributes attributes) {
        this.span.addEvent(name, attributes);
        return this;
    }

    public ReactiveSpan addEvent(@Nonnull String name, @Nonnull Attributes attributes, long timestamp, @Nonnull TimeUnit unit) {
        this.span.addEvent(name, attributes, timestamp, unit);
        return this;
    }

    @Override
    public ReactiveSpan setStatus(@Nonnull StatusCode statusCode, @Nonnull String description) {
        this.stateSet = true;
        this.span.setStatus(statusCode, description);
        return this;
    }

    public ReactiveSpan recordException(@Nonnull Throwable exception, @Nonnull Attributes additionalAttributes) {
        this.span.recordException(exception, additionalAttributes);
        return this;
    }

    public ReactiveSpan updateName(@Nonnull String name) {
        this.span.updateName(name);
        return this;
    }

    public void end() {
    }

    public void end(long timestamp, @Nonnull TimeUnit unit) {
    }

    public SpanContext getSpanContext() {
        return this.span.getSpanContext();
    }

    public boolean isRecording() {
        return this.span.isRecording();
    }

    public Context storeInContext(@Nonnull Context context) {
        return this.span.storeInContext(context);
    }
}

