/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections.MapUtils;
import org.jetlinks.core.topic.Topic;
import org.jetlinks.core.trace.MapTextMapGetter;
import org.jetlinks.core.trace.ReactiveSpan;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.function.Consumer3;
import reactor.util.context.ContextView;

public class TraceHolder {
    static final ContextKey<CharSequence> SPAN_NAME = ContextKey.named((String)"spanName");
    private static String GLOBAL_APP_NAME = System.getProperty("trace.app.name", "default");
    private static boolean traceEnabled = Boolean.parseBoolean(System.getProperty("trace.enabled", "true"));
    private static final Topic<String> disabledSpanName = Topic.createRoot();
    private static final Topic<String> enabledSpanName = Topic.createRoot();
    private static OpenTelemetry telemetry;

    public static void setup(OpenTelemetry telemetry) {
        TraceHolder.telemetry = telemetry;
    }

    public static void setupGlobalName(String name) {
        GLOBAL_APP_NAME = name;
    }

    public static String appName() {
        return GLOBAL_APP_NAME;
    }

    public static boolean isEnabled() {
        return traceEnabled && telemetry != null;
    }

    public static boolean isDisabled() {
        return telemetry == null || !TraceHolder.isEnabled();
    }

    public static boolean isEnabled(String name) {
        return TraceHolder.isEnabled((CharSequence)name);
    }

    public static boolean isEnabled(CharSequence name) {
        if (!traceEnabled) {
            return false;
        }
        AtomicReference enabled = new AtomicReference();
        enabledSpanName.findTopic(name, enabled, (e, topic) -> e.set(true), e -> {});
        if (enabled.get() == null) {
            disabledSpanName.findTopic(name, enabled, (e, topic) -> e.set(false), e -> {});
        }
        if (enabled.get() == null) {
            return true;
        }
        return (Boolean)enabled.get();
    }

    public static boolean isDisabled(String name) {
        return telemetry == null || !TraceHolder.isEnabled(name);
    }

    public static boolean isDisabled(CharSequence name) {
        return telemetry == null || !TraceHolder.isEnabled(name);
    }

    public static void enable() {
        traceEnabled = true;
    }

    public static void disable() {
        traceEnabled = false;
    }

    public static Disposable enable(String spanName, String handler) {
        TraceHolder.removeDisabled(spanName, handler);
        Topic<String> subTable = enabledSpanName.append(spanName);
        subTable.subscribe((String[])new String[]{handler});
        return () -> subTable.unsubscribe(handler);
    }

    public static void removeEnabled(String spanName, String handler) {
        enabledSpanName.getTopic(spanName).ifPresent(topic -> topic.unsubscribe(handler));
    }

    public static void removeDisabled(String spanName, String handler) {
        disabledSpanName.getTopic(spanName).ifPresent(topic -> topic.unsubscribe(handler));
    }

    public static void disable(String spanName, String handler) {
        disabledSpanName.append(spanName).subscribe((String[])new String[]{handler});
        TraceHolder.removeEnabled(spanName, handler);
    }

    public static OpenTelemetry telemetry() {
        return telemetry == null ? OpenTelemetry.noop() : telemetry;
    }

    public static reactor.util.context.Context readToContext(ContextView parent, Map<String, ?> carrier) {
        if (TraceHolder.isDisabled() || MapUtils.isEmpty(carrier)) {
            return reactor.util.context.Context.of((ContextView)parent);
        }
        return TraceHolder.readToContext(parent, carrier, MapTextMapGetter.instance());
    }

    public static <T> reactor.util.context.Context readToContext(ContextView parent, T source, TextMapGetter<T> getter) {
        ContextPropagators propagators = TraceHolder.telemetry().getPropagators();
        TextMapPropagator propagator = propagators.getTextMapPropagator();
        Context context = (Context)parent.getOrDefault(Context.class, (Object)Context.current());
        if (null != context) {
            context = propagator.extract(context, source, getter);
            return reactor.util.context.Context.of((ContextView)parent).put(Context.class, (Object)context);
        }
        return reactor.util.context.Context.of((ContextView)parent);
    }

    public static <T> T writeContextTo(ContextView ctx, T carrier, Consumer3<T, String, String> setter) {
        if (TraceHolder.isDisabled()) {
            return carrier;
        }
        ContextPropagators propagators = TraceHolder.telemetry().getPropagators();
        TextMapPropagator propagator = propagators.getTextMapPropagator();
        Context context = (Context)ctx.getOrDefault(Context.class, (Object)Context.current());
        if (null != context) {
            propagator.inject(context, carrier, (arg_0, arg_1, arg_2) -> setter.accept(arg_0, arg_1, arg_2));
        }
        return carrier;
    }

    public static <T> T writeTo(T carrier, Consumer3<T, String, String> setter) {
        if (TraceHolder.isDisabled()) {
            return carrier;
        }
        ContextPropagators propagators = TraceHolder.telemetry().getPropagators();
        TextMapPropagator propagator = propagators.getTextMapPropagator();
        Context context = Context.current();
        if (null != context) {
            propagator.inject(context, carrier, (arg_0, arg_1, arg_2) -> setter.accept(arg_0, arg_1, arg_2));
        }
        return carrier;
    }

    public static <T> Mono<T> writeContextTo(T carrier, Consumer3<T, String, String> setter) {
        if (TraceHolder.isDisabled()) {
            return Mono.just(carrier);
        }
        return Mono.deferContextual(ctx -> Mono.just((Object)TraceHolder.writeContextTo(ctx, carrier, setter)));
    }

    public static <D> D copyContext(Map<String, ?> source, D carrier, Consumer3<D, String, String> setter) {
        if (TraceHolder.isDisabled()) {
            return carrier;
        }
        return TraceHolder.writeContextTo((ContextView)TraceHolder.readToContext((ContextView)reactor.util.context.Context.empty(), source), carrier, setter);
    }

    public static void traceBlocking(String operation, Consumer<ReactiveSpan> task) {
        TraceHolder.traceBlocking(operation, (ReactiveSpan span) -> {
            task.accept((ReactiveSpan)span);
            return null;
        });
    }

    public static <R> R traceBlocking(String operation, Function<ReactiveSpan, R> function) {
        return TraceHolder.traceBlocking(Context.current(), operation, function);
    }

    public static <R> R traceBlocking(CharSequence operation, Function<ReactiveSpan, R> function) {
        return TraceHolder.traceBlocking(Context.current(), operation, function);
    }

    /*
     * Exception decompiling
     */
    public static <R> R traceBlocking(Context context, CharSequence operation, Function<ReactiveSpan, R> function) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <R> R traceBlocking(Context context, String operation, Function<ReactiveSpan, R> function) {
        return TraceHolder.traceBlocking(context, (CharSequence)operation, function);
    }
}

