/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jetlinks.core.Lazy;
import org.jetlinks.core.LazyConverter;
import org.jetlinks.core.trace.ReactiveSpanBuilder;

public class ReactiveSpanBuilderWrapper
implements ReactiveSpanBuilder {
    private final SpanBuilder spanBuilder;

    @Override
    public <T> ReactiveSpanBuilder setAttributeLazy(AttributeKey<T> key, Supplier<T> lazyValue) {
        this.spanBuilder.setAttribute(key, lazyValue instanceof Lazy ? lazyValue : Lazy.of(lazyValue));
        return this;
    }

    @Override
    public <V, T> ReactiveSpanBuilder setAttributeLazy(AttributeKey<T> key, V value, Function<V, T> lazyValue) {
        this.spanBuilder.setAttribute(key, lazyValue instanceof LazyConverter ? lazyValue : LazyConverter.of(value, lazyValue));
        return this;
    }

    @Override
    public ReactiveSpanBuilder setParent(@Nonnull Context context) {
        this.spanBuilder.setParent(context);
        return this;
    }

    @Override
    public ReactiveSpanBuilder setNoParent() {
        this.spanBuilder.setNoParent();
        return this;
    }

    public ReactiveSpanBuilder addLink(@Nonnull SpanContext spanContext) {
        this.spanBuilder.addLink(spanContext);
        return this;
    }

    public ReactiveSpanBuilder addLink(@Nonnull SpanContext spanContext, @Nonnull Attributes attributes) {
        this.spanBuilder.addLink(spanContext, attributes);
        return this;
    }

    @Override
    public ReactiveSpanBuilder setAttribute(@Nonnull String key, @Nonnull String value) {
        this.spanBuilder.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpanBuilder setAttribute(@Nonnull String key, long value) {
        this.spanBuilder.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpanBuilder setAttribute(@Nonnull String key, double value) {
        this.spanBuilder.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpanBuilder setAttribute(@Nonnull String key, boolean value) {
        this.spanBuilder.setAttribute(key, value);
        return this;
    }

    @Override
    public <T> ReactiveSpanBuilder setAttribute(@Nonnull AttributeKey<T> key, @Nonnull T value) {
        this.spanBuilder.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpanBuilder setSpanKind(@Nonnull SpanKind spanKind) {
        this.spanBuilder.setSpanKind(spanKind);
        return this;
    }

    @Override
    public ReactiveSpanBuilder setStartTimestamp(long startTimestamp, @Nonnull TimeUnit unit) {
        this.spanBuilder.setStartTimestamp(startTimestamp, unit);
        return this;
    }

    @Override
    public ReactiveSpanBuilder setStartTimestamp(@Nonnull Instant startTimestamp) {
        this.spanBuilder.setStartTimestamp(startTimestamp);
        return this;
    }

    @Override
    public ReactiveSpanBuilder setAllAttributes(@Nonnull Attributes attributes) {
        this.spanBuilder.setAllAttributes(attributes);
        return this;
    }

    public Span startSpan() {
        return this.spanBuilder.startSpan();
    }

    public ReactiveSpanBuilderWrapper(SpanBuilder spanBuilder) {
        this.spanBuilder = spanBuilder;
    }
}

