/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jetlinks.core.trace.ReactiveSpanWrapper;

public interface ReactiveSpan
extends Span {
    public static ReactiveSpan wrap(Span span) {
        if (span instanceof ReactiveSpan) {
            return (ReactiveSpan)span;
        }
        return new ReactiveSpanWrapper(span);
    }

    public static ReactiveSpan noop() {
        return new ReactiveSpanWrapper(Span.getInvalid());
    }

    public <T> ReactiveSpan setAttributeLazy(AttributeKey<T> var1, Supplier<T> var2);

    default public <V, T> ReactiveSpan setAttributeLazy(AttributeKey<T> key, V value, Function<V, T> lazyValue) {
        return this.setAttributeLazy(key, () -> lazyValue.apply(value));
    }

    public <T> ReactiveSpan setAttribute(@Nonnull AttributeKey<T> var1, @Nonnull T var2);

    public ReactiveSpan setStatus(@Nonnull StatusCode var1, @Nonnull String var2);

    default public ReactiveSpan setAttribute(@Nonnull String key, long value) {
        super.setAttribute(key, value);
        return this;
    }

    default public ReactiveSpan setAttribute(@Nonnull String key, double value) {
        super.setAttribute(key, value);
        return this;
    }

    default public ReactiveSpan setAttribute(@Nonnull String key, @Nonnull String value) {
        super.setAttribute(key, value);
        return this;
    }

    default public ReactiveSpan setAttribute(@Nonnull String key, boolean value) {
        super.setAttribute(key, value);
        return this;
    }

    default public ReactiveSpan setAttribute(@Nonnull AttributeKey<Long> key, int value) {
        super.setAttribute(key, value);
        return this;
    }

    default public ReactiveSpan setStatus(@Nonnull StatusCode statusCode) {
        super.setStatus(statusCode);
        return this;
    }
}

