/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.context.propagation.TextMapGetter;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections.MapUtils;
import org.jetlinks.core.trace.MapTextMapGetter;
import org.jetlinks.core.trace.MonoTracerBuilder;
import org.jetlinks.core.trace.ReactiveSpan;
import org.jetlinks.core.trace.ReactiveSpanBuilder;
import org.jetlinks.core.trace.ReactiveTracerBuilder;
import org.jetlinks.core.trace.TraceHolder;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public interface MonoTracer<T>
extends Function<Mono<T>, Mono<T>> {
    public static <T> MonoTracer<T> unsupported() {
        return source -> source;
    }

    public static <T> ReactiveTracerBuilder<MonoTracer<T>, T> builder() {
        return MonoTracerBuilder.create(true);
    }

    public static <T> MonoTracer<T> create(String spanName) {
        return MonoTracer.create(TraceHolder.appName(), spanName);
    }

    public static <T> MonoTracer<T> create(CharSequence spanName) {
        return MonoTracer.create(TraceHolder.appName(), spanName);
    }

    public static <T> MonoTracer<T> create(String scopeName, String spanName) {
        return MonoTracer.create(scopeName, spanName, null, null);
    }

    public static <T> MonoTracer<T> create(String scopeName, CharSequence spanName) {
        return MonoTracer.create(scopeName, spanName, null, null);
    }

    public static <T> MonoTracer<T> create(String spanName, BiConsumer<ReactiveSpan, T> onNext) {
        return MonoTracer.create(TraceHolder.appName(), spanName, onNext, null);
    }

    public static <T> MonoTracer<T> create(CharSequence spanName, BiConsumer<ReactiveSpan, T> onNext) {
        return MonoTracer.create(TraceHolder.appName(), spanName, onNext, null);
    }

    public static <T> MonoTracer<T> create(String scopeName, String spanName, BiConsumer<ReactiveSpan, T> onNext) {
        return MonoTracer.create(scopeName, spanName, onNext, null);
    }

    public static <T> MonoTracer<T> create(String spanName, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return MonoTracer.create(TraceHolder.appName(), spanName, null, builderConsumer);
    }

    public static <T> MonoTracer<T> create(CharSequence spanName, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return MonoTracer.create(TraceHolder.appName(), spanName, null, builderConsumer);
    }

    public static <T> MonoTracer<T> create(String scopeName, String spanName, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return MonoTracer.create(scopeName, spanName, null, builderConsumer);
    }

    public static <T> MonoTracer<T> create(String spanName, BiConsumer<ReactiveSpan, T> onNext, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return MonoTracer.create(TraceHolder.appName(), spanName, onNext, builderConsumer);
    }

    public static <T> MonoTracer<T> create(String spanName, BiConsumer<ReactiveSpan, T> onNext, BiConsumer<ReactiveSpan, Boolean> onComplete) {
        return MonoTracer.create(TraceHolder.appName(), spanName, onNext, onComplete, null);
    }

    public static <T> MonoTracer<T> create(CharSequence spanName, BiConsumer<ReactiveSpan, T> onNext, BiConsumer<ReactiveSpan, Boolean> onComplete) {
        return MonoTracer.create(TraceHolder.appName(), spanName, onNext, onComplete, null);
    }

    public static <T> MonoTracer<T> create(String scopeName, String spanName, BiConsumer<ReactiveSpan, T> onNext, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return MonoTracer.create(scopeName, spanName, onNext, null, builderConsumer);
    }

    public static <T> MonoTracer<T> create(String scopeName, CharSequence spanName, BiConsumer<ReactiveSpan, T> onNext, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return MonoTracer.create(scopeName, spanName, onNext, null, builderConsumer);
    }

    public static <T> MonoTracer<T> create(String scopeName, String spanName, BiConsumer<ReactiveSpan, T> onNext, BiConsumer<ReactiveSpan, Boolean> onComplete, Consumer<ReactiveSpanBuilder> builderConsumer) {
        if (TraceHolder.isDisabled()) {
            return MonoTracer.unsupported();
        }
        return (MonoTracer)MonoTracerBuilder.create(true).scopeName(scopeName).spanName(spanName).onNext(onNext).onComplete(onComplete != null ? (span, total) -> onComplete.accept((ReactiveSpan)span, total > 0L) : null).onSubscription(builderConsumer).build();
    }

    public static <T> MonoTracer<T> create(String scopeName, CharSequence spanName, BiConsumer<ReactiveSpan, T> onNext, BiConsumer<ReactiveSpan, Boolean> onComplete, Consumer<ReactiveSpanBuilder> builderConsumer) {
        if (TraceHolder.isDisabled()) {
            return MonoTracer.unsupported();
        }
        return (MonoTracer)MonoTracerBuilder.create(true).scopeName(scopeName).spanName(spanName).onNext(onNext).onComplete(onComplete != null ? (span, total) -> onComplete.accept((ReactiveSpan)span, total > 0L) : null).onSubscription(builderConsumer).build();
    }

    public static <R> MonoTracer<R> createWith(Map<String, ?> carrier) {
        if (TraceHolder.isDisabled() || MapUtils.isEmpty(carrier)) {
            return MonoTracer.unsupported();
        }
        return MonoTracer.createWith(carrier, MapTextMapGetter.instance());
    }

    public static <T, R> MonoTracer<R> createWith(T source, TextMapGetter<T> getter) {
        if (TraceHolder.isDisabled()) {
            return MonoTracer.unsupported();
        }
        return mono -> mono.contextWrite(ctx -> TraceHolder.readToContext((ContextView)ctx, source, getter));
    }
}

