/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.topic;

import com.google.common.collect.Collections2;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.MapUtils;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SharedPathString;
import org.jetlinks.core.topic.TopicView;
import org.jetlinks.core.utils.RecyclableDequeue;
import org.jetlinks.core.utils.RecyclerUtils;
import org.jetlinks.core.utils.TopicUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.function.Consumer3;
import reactor.function.Consumer4;
import reactor.function.Consumer5;

public final class Topic<T>
implements SeparatedCharSequence {
    private int $hash;
    private final Topic<T> parent;
    private String part;
    private volatile SharedPathString topics;
    private final int depth;
    private volatile ConcurrentMap<String, Topic<T>> child;
    private volatile ConcurrentMap<T, Integer> subscribers;

    public static <T> Topic<T> createRoot() {
        return new Topic<T>(null, "/");
    }

    public Topic<T> append(String topic) {
        if (topic == null || topic.equals("/") || topic.isEmpty()) {
            return this;
        }
        return this.getOrDefault(topic, Topic::new);
    }

    public Topic<T> append(String[] topic) {
        if (topic == null || topic.length == 0) {
            return this;
        }
        return this.getOrDefault(topic, Topic::new);
    }

    private Topic(Topic<T> parent, String part) {
        if (ObjectUtils.isEmpty((Object)part) || part.equals("/")) {
            this.part = "";
        } else if (part.contains("/")) {
            this.ofTopic(part);
        } else {
            this.setPart(part);
        }
        this.parent = parent;
        this.depth = null != parent ? parent.depth + 1 : 0;
    }

    private void setPart(String part) {
        this.part = RecyclerUtils.intern(part);
    }

    private String[] getTopicsUnsafe() {
        return this.topic().unsafeSeparated();
    }

    public String getTopic() {
        return SharedPathString.of(this.asStringArray()).toString();
    }

    private SharedPathString topic() {
        if (this.topics == null) {
            this.topics = SharedPathString.of(this.asStringArray()).intern();
        }
        return this.topics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public T getSubscriberOrSubscribe(Supplier<T> supplier) {
        if (!this.subscribers().isEmpty()) {
            return (T)this.subscribers().keySet().iterator().next();
        }
        Topic topic = this;
        synchronized (topic) {
            if (!this.subscribers().isEmpty()) {
                return (T)this.subscribers().keySet().iterator().next();
            }
            T sub = supplier.get();
            this.subscribe(sub);
            return sub;
        }
    }

    public Set<T> getSubscribers() {
        return this.subscribers == null ? Collections.emptySet() : this.subscribers().keySet();
    }

    public boolean subscribed(T subscriber) {
        return this.subscribers != null && this.subscribers().containsKey(subscriber);
    }

    @SafeVarargs
    public final void subscribe(T ... subscribers) {
        for (T subscriber : subscribers) {
            this.subscribe0(subscriber);
        }
    }

    public void subscribe0(T subscriber) {
        this.subscribers().compute(subscriber, (ignore, i) -> i == null ? 1 : i + 1);
    }

    public void subscribe0(T subscriber, boolean replace) {
        if (replace) {
            this.subscribers().put(subscriber, 1);
            return;
        }
        this.subscribe0(subscriber);
    }

    @SafeVarargs
    public final List<T> unsubscribe(T ... subscribers) {
        ArrayList<T> unsub = new ArrayList<T>(subscribers.length);
        for (T subscriber : subscribers) {
            if (!this.unsubscribe0(subscriber)) continue;
            unsub.add(subscriber);
        }
        return unsub;
    }

    public boolean unsubscribe0(T subscriber, boolean all) {
        if (all) {
            return this.subscribers().remove(subscriber) != null;
        }
        return this.unsubscribe0(subscriber);
    }

    public boolean unsubscribe0(T subscriber) {
        return this.subscribers().compute(subscriber, (k, v) -> {
            if (v == null || v - 1 <= 0) {
                return null;
            }
            return v - 1;
        }) == null;
    }

    public void unsubscribe(Predicate<T> predicate) {
        ConcurrentMap<T, Integer> subscribers = this.subscribers;
        if (subscribers == null) {
            return;
        }
        for (Object t : subscribers.keySet()) {
            if (!predicate.test(t)) continue;
            this.unsubscribe0(t);
        }
    }

    public void unsubscribeAll() {
        if (this.subscribers == null) {
            return;
        }
        this.subscribers.clear();
    }

    public Collection<Topic<T>> getChildren() {
        if (this.child == null) {
            return Collections.emptyList();
        }
        return this.child.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Topic<T>> child() {
        if (this.child == null) {
            Topic topic = this;
            synchronized (topic) {
                if (this.child == null) {
                    this.child = new ConcurrentHashMap<String, Topic<T>>(1);
                }
            }
        }
        return this.child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<T, Integer> subscribers() {
        if (this.subscribers == null) {
            Topic topic = this;
            synchronized (topic) {
                if (this.subscribers == null) {
                    this.subscribers = new ConcurrentHashMap<T, Integer>(1);
                }
            }
        }
        return this.subscribers;
    }

    private void ofTopic(String topic) {
        String[] parts = topic.split("/", 2);
        this.setPart(parts[0]);
        if (parts.length > 1) {
            Topic<T> part = new Topic<T>(this, parts[1]);
            this.child().put(part.part, part);
        }
    }

    private Topic<T> getOrDefault(String[] parts, BiFunction<Topic<T>, String, Topic<T>> mapping) {
        int index = 0;
        if (parts[0].isEmpty()) {
            index = 1;
        }
        Topic part = this.child().computeIfAbsent(parts[index], _topic -> (Topic)mapping.apply(this, (String)_topic));
        for (int i = index + 1; i < parts.length && part != null; ++i) {
            Topic parent = part;
            part = part.child().computeIfAbsent(parts[i], _topic -> (Topic)mapping.apply(parent, (String)_topic));
        }
        return part;
    }

    private Topic<T> getOrDefault(String topic, BiFunction<Topic<T>, String, Topic<T>> mapping) {
        if (topic.charAt(0) == '/') {
            topic = topic.substring(1);
        }
        String[] parts = TopicUtils.split(topic, true, true);
        Topic part = this.child().computeIfAbsent(parts[0], _topic -> (Topic)mapping.apply(this, (String)_topic));
        for (int i = 1; i < parts.length && part != null; ++i) {
            Topic parent = part;
            part = part.child().computeIfAbsent(parts[i], _topic -> (Topic)mapping.apply(parent, (String)_topic));
        }
        return part;
    }

    public Optional<Topic<T>> getTopic(String topic) {
        return Optional.ofNullable(this.getOrDefault(topic, (Topic<T> topicPart, String s) -> null));
    }

    public Optional<Topic<T>> getTopic(String[] topic) {
        return Optional.ofNullable(this.getOrDefault(topic, (Topic<T> topicPart, String s) -> null));
    }

    public Flux<Topic<T>> findTopic(String topic) {
        return Flux.create(sink -> this.findTopic(topic, arg_0 -> ((FluxSink)sink).next(arg_0), () -> ((FluxSink)sink).complete()));
    }

    public void findTopic(String topic, Consumer<Topic<T>> sink, Runnable end) {
        this.findTopic(topic, null, null, end, sink, (nil, nil2, _end, _sink, _topic) -> _sink.accept(_topic), (nil, nil2, _end, _sink) -> _end.run());
    }

    public <A> void findTopic(CharSequence topic, A arg1, BiConsumer<A, Topic<T>> sink, Consumer<A> end) {
        if (topic instanceof SeparatedCharSequence) {
            Topic.find((SeparatedCharSequence)topic, this, arg1, null, end, sink, (a1, nil2, _end, _sink, _topic) -> _sink.accept(a1, _topic), (a1, nil2, _end, _sink) -> _end.accept(a1));
        } else {
            this.findTopic(topic.toString(), arg1, null, end, sink, (a1, nil2, _end, _sink, _topic) -> _sink.accept(a1, _topic), (a1, nil2, _end, _sink) -> _end.accept(a1));
        }
    }

    public <A, B> void findTopic(CharSequence topic, A arg1, B arg2, Consumer3<A, B, Topic<T>> sink, BiConsumer<A, B> end) {
        if (topic instanceof SeparatedCharSequence) {
            Topic.find((SeparatedCharSequence)topic, this, arg1, arg2, end, sink, (a1, b, _end, _sink, _topic) -> _sink.accept(a1, b, _topic), (a1, b, _end, _sink) -> _end.accept(a1, b));
        } else {
            this.findTopic(topic.toString(), arg1, arg2, end, sink, (a1, b, _end, _sink, _topic) -> _sink.accept(a1, b, _topic), (a1, b, _end, _sink) -> _end.accept(a1, b));
        }
    }

    public void findTopic(CharSequence topic, Consumer<Topic<T>> sink, Runnable end) {
        if (topic instanceof SeparatedCharSequence) {
            Topic.find((SeparatedCharSequence)topic, this, null, null, end, sink, (nil, nil2, _end, _sink, _topic) -> _sink.accept(_topic), (nil, nil2, _end, _sink) -> _end.run());
        } else {
            this.findTopic(topic.toString(), null, null, end, sink, (nil, nil2, _end, _sink, _topic) -> _sink.accept(_topic), (nil, nil2, _end, _sink) -> _end.run());
        }
    }

    public <ARG0, ARG1, ARG2, ARG3> void findTopic(CharSequence topic, ARG0 arg0, ARG1 arg1, ARG2 arg2, ARG3 arg3, Consumer5<ARG0, ARG1, ARG2, ARG3, Topic<T>> sink, Consumer4<ARG0, ARG1, ARG2, ARG3> end) {
        if (topic instanceof SeparatedCharSequence) {
            Topic.find((SeparatedCharSequence)topic, this, arg0, arg1, arg2, arg3, sink, end);
        } else {
            this.findTopic(topic.toString(), arg0, arg1, arg2, arg3, sink, end);
        }
    }

    public <ARG0, ARG1, ARG2, ARG3> void findTopic(String topic, ARG0 arg0, ARG1 arg1, ARG2 arg2, ARG3 arg3, Consumer5<ARG0, ARG1, ARG2, ARG3, Topic<T>> sink, Consumer4<ARG0, ARG1, ARG2, ARG3> end) {
        String[] topics = TopicUtils.split(topic, false, false);
        if (topic.charAt(0) != '/') {
            String[] newTopics = new String[topics.length + 1];
            newTopics[0] = "";
            System.arraycopy(topics, 0, newTopics, 1, topics.length);
            topics = newTopics;
        }
        Topic.find(topics, this, arg0, arg1, arg2, arg3, sink, end);
    }

    @Override
    public char separator() {
        return '/';
    }

    @Override
    public int size() {
        return this.depth + 1;
    }

    @Override
    public CharSequence get(int index) {
        Topic<T> topic = this;
        while (topic.depth != index) {
            topic = topic.parent;
            if (topic != null) continue;
            throw new StringIndexOutOfBoundsException(index);
        }
        return topic.part;
    }

    @Override
    public SeparatedCharSequence replace(int index, CharSequence newChar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeparatedCharSequence append(char c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeparatedCharSequence append(CharSequence csq) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeparatedCharSequence append(CharSequence ... csq) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeparatedCharSequence append(CharSequence csq, int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeparatedCharSequence range(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeparatedCharSequence intern() {
        return this.internInner();
    }

    @Override
    public int length() {
        int len = 0;
        Topic<T> topic = this;
        while (topic != null) {
            len += topic.part.length();
            topic = topic.parent;
        }
        return len;
    }

    @Override
    public char charAt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public String toString() {
        return "topic: " + this.getTopic() + ", subscribers: " + (this.subscribers == null ? 0 : this.subscribers.size()) + ", children: " + (this.child == null ? 0 : this.child.size());
    }

    private boolean match(String[] pars) {
        return this.match(SharedPathString.of(pars));
    }

    private boolean match(SeparatedCharSequence parts) {
        SeparatedCharSequence self = this.topics != null ? this.topics : this;
        return TopicUtils.match(parts, self) || TopicUtils.match(self, parts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, ARG0, ARG1, ARG2, ARG3> void find(String[] topicParts, Topic<T> topicPart, ARG0 arg0, ARG1 arg1, ARG2 arg2, ARG3 arg3, Consumer5<ARG0, ARG1, ARG2, ARG3, Topic<T>> sink, Consumer4<ARG0, ARG1, ARG2, ARG3> end) {
        RecyclableDequeue cache = RecyclerUtils.dequeue();
        try {
            cache.add(topicPart);
            String nextPart = null;
            while (!cache.isEmpty()) {
                ConcurrentMap<String, Topic<T>> child;
                Topic part = (Topic)cache.poll();
                if (part == null) {
                    break;
                }
                if (part.match(topicParts)) {
                    sink.accept(arg0, arg1, arg2, arg3, (Object)part);
                }
                if ((child = part.child) == null) continue;
                if (part.part.equals("**")) {
                    Topic tmp = null;
                    for (int i = part.depth; i < topicParts.length; ++i) {
                        tmp = (Topic)child.get(topicParts[i]);
                        if (tmp == null) continue;
                        cache.add(tmp);
                    }
                    if (null != tmp) continue;
                }
                if ("**".equals(nextPart) || "*".equals(nextPart)) {
                    cache.addAll(child.values());
                    continue;
                }
                Topic next = (Topic)child.get("**");
                if (next != null) {
                    cache.add(next);
                }
                if ((next = (Topic)child.get("*")) != null) {
                    cache.add(next);
                }
                if (part.depth + 1 >= topicParts.length) continue;
                nextPart = topicParts[part.depth + 1];
                if (nextPart.equals("*") || nextPart.equals("**")) {
                    cache.addAll(child.values());
                    continue;
                }
                next = (Topic)child.get(nextPart);
                if (next == null) continue;
                cache.add(next);
            }
        }
        finally {
            end.accept(arg0, arg1, arg2, arg3);
            cache.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, ARG0, ARG1, ARG2, ARG3> void find(SeparatedCharSequence topicParts, Topic<T> topicPart, ARG0 arg0, ARG1 arg1, ARG2 arg2, ARG3 arg3, Consumer5<ARG0, ARG1, ARG2, ARG3, Topic<T>> sink, Consumer4<ARG0, ARG1, ARG2, ARG3> end) {
        RecyclableDequeue cache = RecyclerUtils.dequeue();
        try {
            cache.add(topicPart);
            String nextPart = null;
            while (!cache.isEmpty()) {
                ConcurrentMap<String, Topic<T>> child;
                Topic part = (Topic)cache.poll();
                if (part == null) {
                    break;
                }
                if (part.match(topicParts)) {
                    sink.accept(arg0, arg1, arg2, arg3, (Object)part);
                }
                if ((child = part.child) == null) continue;
                int partsSize = topicParts.size();
                if (part.part.equals("**")) {
                    Topic tmp = null;
                    for (int i = part.depth; i < partsSize; ++i) {
                        tmp = (Topic)child.get(topicParts.get(i).toString());
                        if (tmp == null) continue;
                        cache.add(tmp);
                    }
                    if (null != tmp) continue;
                }
                if ("**".equals(nextPart) || "*".equals(nextPart)) {
                    cache.addAll(child.values());
                    continue;
                }
                Topic next = (Topic)child.get("**");
                if (next != null) {
                    cache.add(next);
                }
                if ((next = (Topic)child.get("*")) != null) {
                    cache.add(next);
                }
                if (part.depth + 1 >= partsSize) continue;
                nextPart = topicParts.get(part.depth + 1).toString();
                if (nextPart.equals("*") || nextPart.equals("**")) {
                    cache.addAll(child.values());
                    continue;
                }
                next = (Topic)child.get(nextPart);
                if (next == null) continue;
                cache.add(next);
            }
        }
        finally {
            end.accept(arg0, arg1, arg2, arg3);
            cache.recycle();
        }
    }

    public long getTotalTopic() {
        ConcurrentMap<String, Topic<T>> child = this.child;
        long total = child == null ? 0L : (long)child.size();
        for (Topic<T> tTopic : this.getChildren()) {
            total += tTopic.getTotalTopic();
        }
        return total;
    }

    public long getTotalSubscriber() {
        ConcurrentMap<T, Integer> subscribers = this.subscribers;
        long total = subscribers == null ? 0L : (long)subscribers.size();
        for (Topic<T> tTopic : this.getChildren()) {
            total += tTopic.getTotalSubscriber();
        }
        return total;
    }

    public Flux<Topic<T>> getAllSubscriber() {
        return Flux.create(sink -> {
            this.walkChildren((FluxSink<Topic<T>>)sink);
            sink.complete();
        });
    }

    private void walkChildren(FluxSink<Topic<T>> sink) {
        for (Topic<T> tTopic : this.getChildren()) {
            if (sink.isCancelled()) break;
            sink.next(tTopic);
            super.walkChildren(sink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanup(BiConsumer<Boolean, Topic<T>> handler) {
        Object object;
        if (this.subscribers != null && this.subscribers.isEmpty()) {
            object = this;
            synchronized (object) {
                if (this.subscribers.isEmpty()) {
                    this.subscribers = null;
                }
            }
        }
        if (this.child != null) {
            for (Map.Entry entry : this.child.entrySet()) {
                Topic topic = (Topic)entry.getValue();
                boolean cleaned = topic.cleanup(handler);
                if (cleaned) {
                    this.child.remove(entry.getKey());
                }
                if (handler == null) continue;
                handler.accept(cleaned, topic);
            }
            if (this.child != null && this.child.isEmpty()) {
                object = this;
                synchronized (object) {
                    if (this.child.isEmpty()) {
                        this.child = null;
                    }
                }
            }
        }
        return CollectionUtils.isEmpty(this.subscribers) && CollectionUtils.isEmpty(this.child);
    }

    public boolean cleanup() {
        return this.cleanup(null);
    }

    public void clean() {
        this.unsubscribeAll();
        if (this.child != null) {
            this.child.values().forEach(Topic::clean);
            this.child().clear();
        }
    }

    @Override
    public int compareTo(@Nonnull SeparatedCharSequence obj) {
        if (this == obj) {
            return 0;
        }
        if (!(obj instanceof Topic)) {
            return this.getTopic().compareTo(obj.toString());
        }
        Topic<T> left = (Topic<T>)obj;
        Topic<T> right = this;
        if (left.depth != right.depth) {
            return Integer.compare(left.depth, right.depth);
        }
        while (left != null && right != null) {
            int compare = left.part.compareTo(right.part);
            if (compare != 0) {
                return compare;
            }
            left = left.parent;
            right = right.parent;
        }
        return 0;
    }

    @Override
    public Topic<T> internInner() {
        this.part = RecyclerUtils.intern(this.part);
        SharedPathString topics = this.topics;
        if (topics != null) {
            topics.internInner();
        }
        return this;
    }

    public int hashCode() {
        if (this.$hash == 0) {
            Topic<T> t = this;
            while (t != null) {
                this.$hash = 31 * this.$hash + t.part.hashCode();
                t = t.parent;
            }
        }
        return this.$hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Topic)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Topic<T> left = (Topic<T>)obj;
        Topic<T> right = this;
        while (left != null && right != null) {
            if (left.depth != right.depth || !Objects.equals(left.part, right.part)) {
                return false;
            }
            left = left.parent;
            right = right.parent;
        }
        return left == null && right == null;
    }

    @Override
    public String[] asStringArray() {
        String[] arr = new String[this.depth + 1];
        Topic<T> topic = this;
        for (int i = arr.length - 1; i >= 0 && topic != null; --i) {
            arr[i] = topic.part;
            topic = topic.parent;
        }
        return arr;
    }

    public void writeTo(DataOutput output) throws IOException {
        int size = this.depth + 1;
        output.writeShort(size);
        Topic<T> topic = this;
        for (int i = 0; i < size && topic != null; ++i) {
            output.writeUTF(topic.part);
            topic = topic.parent;
        }
    }

    public static String[] readArray(DataInput input) throws IOException {
        int len = input.readUnsignedShort();
        String[] arr = new String[len];
        for (int i = arr.length - 1; i >= 0; --i) {
            arr[i] = input.readUTF();
        }
        return arr;
    }

    public TopicView view() {
        ConcurrentMap<String, Topic<T>> child;
        TopicView view = new TopicView();
        view.setPart(this.part);
        ConcurrentMap<T, Integer> subscribers = this.subscribers;
        if (MapUtils.isNotEmpty(subscribers)) {
            view.setSubscribers(subscribers.keySet());
        }
        if ((child = this.child) != null) {
            view.setChildren(Collections2.transform(child.values(), Topic::view));
        }
        return view;
    }

    public Topic<T> getParent() {
        return this.parent;
    }

    private void setTopics(SharedPathString topics) {
        this.topics = topics;
    }
}

