/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things;

import javax.annotation.Nonnull;
import org.jetlinks.core.things.Thing;
import org.jetlinks.core.things.ThingId;
import org.jetlinks.core.things.ThingInfo;
import org.jetlinks.core.things.ThingTemplate;
import org.jetlinks.core.things.ThingTemplateInfo;
import org.jetlinks.core.things.ThingType;
import reactor.core.publisher.Mono;

public interface ThingsRegistry {
    public Mono<Thing> getThing(@Nonnull String var1, @Nonnull String var2);

    public Mono<ThingTemplate> getTemplate(@Nonnull String var1, @Nonnull String var2);

    public Mono<Thing> register(@Nonnull String var1, @Nonnull ThingInfo var2);

    public Mono<Void> unregisterThing(@Nonnull String var1, @Nonnull String var2);

    public Mono<ThingTemplate> register(@Nonnull String var1, @Nonnull ThingTemplateInfo var2);

    public Mono<Void> unregisterTemplate(@Nonnull String var1, @Nonnull String var2);

    default public Mono<Thing> getThing(@Nonnull ThingId thingId) {
        return this.getThing(thingId.getType(), thingId.getId());
    }

    default public Mono<Thing> getThing(@Nonnull ThingType thingType, @Nonnull String thingId) {
        return this.getThing(thingType.getId(), thingId);
    }

    default public Mono<ThingTemplate> getTemplate(@Nonnull ThingType thingType, @Nonnull String templateId) {
        return this.getTemplate(thingType.getId(), templateId);
    }

    default public Mono<Thing> register(@Nonnull ThingType thingType, @Nonnull ThingInfo info) {
        return this.register(thingType.getId(), info);
    }

    default public Mono<Void> unregisterThing(@Nonnull ThingType thingType, @Nonnull String thingId) {
        return this.unregisterThing(thingType.getId(), thingId);
    }

    default public Mono<ThingTemplate> register(@Nonnull ThingType thingType, @Nonnull ThingTemplateInfo templateInfo) {
        return this.register(thingType.getId(), templateInfo);
    }

    default public Mono<Void> unregisterTemplate(@Nonnull ThingType thingType, @Nonnull String templateId) {
        return this.unregisterTemplate(thingType.getId(), templateId);
    }
}

