/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import org.hswebframework.web.utils.DigestUtils;

public class ThingId
implements Externalizable {
    @NonNull
    private String type;
    @NonNull
    private String id;

    public String toUniqueId() {
        return DigestUtils.md5Hex(md5 -> {
            md5.update(this.type.getBytes(StandardCharsets.UTF_8));
            md5.update(this.id.getBytes(StandardCharsets.UTF_8));
        });
    }

    public String toString() {
        return this.type + ":" + this.id;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.type);
        out.writeUTF(this.id);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readUTF();
        this.id = in.readUTF();
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThingId)) {
            return false;
        }
        ThingId other = (ThingId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThingId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public ThingId() {
    }

    private ThingId(@NonNull String type, @NonNull String id) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.type = type;
        this.id = id;
    }

    public static ThingId of(@NonNull String type, @NonNull String id) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return new ThingId(type, id);
    }
}

