/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.session;

import io.netty.util.internal.ThreadLocalRandom;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.session.DeviceSessionManager;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.ClientConnection;
import org.jetlinks.core.server.session.DeviceSession;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Mono;

public abstract class MultiConnectionDeviceSession<C extends ClientConnection>
extends CopyOnWriteArrayList<C>
implements DeviceSession {
    private final Disposable.Composite disposable = Disposables.composite();
    @Generated
    private final String id;
    @Generated
    private final transient DeviceOperator operator;
    protected final transient DeviceSessionManager sessionManager;

    @Override
    public String getDeviceId() {
        return this.id;
    }

    @Override
    public abstract long lastPingTime();

    @Override
    public abstract long connectTime();

    public void registerConnection(C connection) {
        if (!connection.isAlive()) {
            return;
        }
        if (this.addIfAbsent(connection)) {
            connection.onDisconnect(() -> this.handleDisconnect(connection));
        }
    }

    private void handleDisconnect(C connection) {
        this.unregisterConnection(connection);
        this.sessionManager.getSession(this.getDeviceId(), true).subscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterConnection(C connection) {
        MultiConnectionDeviceSession multiConnectionDeviceSession = this;
        synchronized (multiConnectionDeviceSession) {
            this.remove(connection);
        }
    }

    @Override
    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        Object connection = this.takeConnection();
        if (connection == null) {
            return Mono.error((Throwable)new DeviceOperationException.NoStackTrace(ErrorCode.CONNECTION_LOST));
        }
        return Mono.defer(() -> connection.sendMessage(encodedMessage)).thenReturn((Object)true);
    }

    @Override
    public abstract Transport getTransport();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.disposable.dispose();
        MultiConnectionDeviceSession multiConnectionDeviceSession = this;
        synchronized (multiConnectionDeviceSession) {
            for (ClientConnection conn : this) {
                conn.disconnect();
            }
            this.clear();
        }
    }

    @Override
    public abstract void ping();

    @Override
    public boolean isAlive() {
        if (this.disposable.isDisposed()) {
            return false;
        }
        boolean alive = false;
        for (ClientConnection conn : this) {
            alive |= conn.isAlive();
        }
        return alive;
    }

    @Override
    public void onClose(Runnable call) {
        this.disposable.add(call::run);
    }

    @Override
    public Optional<InetSocketAddress> getClientAddress() {
        return Optional.ofNullable(this.takeConnection()).map(ClientConnection::address);
    }

    @Override
    public abstract void setKeepAliveTimeout(Duration var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final C takeConnection() {
        while (true) {
            ClientConnection connection;
            MultiConnectionDeviceSession multiConnectionDeviceSession = this;
            synchronized (multiConnectionDeviceSession) {
                int size = this.size();
                if (size == 0) {
                    return null;
                }
                connection = size == 1 ? (ClientConnection)this.get(0) : (ClientConnection)this.get(ThreadLocalRandom.current().nextInt(size));
            }
            if (connection.isAlive()) {
                return (C)connection;
            }
            connection.disconnect();
            this.handleDisconnect(connection);
        }
    }

    public MultiConnectionDeviceSession(String id, DeviceOperator operator, DeviceSessionManager sessionManager) {
        this.id = id;
        this.operator = operator;
        this.sessionManager = sessionManager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public DeviceOperator getOperator() {
        return this.operator;
    }
}

