/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.route;

import org.jetlinks.core.route.WebsocketRoute;

class DefaultWebsocketRoute
implements WebsocketRoute {
    private final String group;
    private final String address;
    private final String description;
    private final String example;

    DefaultWebsocketRoute(String group, String address, String description, String example) {
        this.group = group;
        this.address = address;
        this.description = description;
        this.example = example;
    }

    public static DefaultWebsocketRouteBuilder builder() {
        return new DefaultWebsocketRouteBuilder();
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getExample() {
        return this.example;
    }

    static class DefaultWebsocketRouteBuilder
    implements WebsocketRoute.Builder {
        private String group;
        private String address;
        private String description;
        private String example;

        DefaultWebsocketRouteBuilder() {
        }

        @Override
        public DefaultWebsocketRouteBuilder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public DefaultWebsocketRouteBuilder path(String path) {
            this.address = path;
            return this;
        }

        @Override
        public DefaultWebsocketRouteBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public DefaultWebsocketRouteBuilder example(String example) {
            this.example = example;
            return this;
        }

        @Override
        public DefaultWebsocketRoute build() {
            return new DefaultWebsocketRoute(this.group, this.address, this.description, this.example);
        }

        public String toString() {
            return "DefaultWebsocketRoute.DefaultWebsocketRouteBuilder(group=" + this.group + ", address=" + this.address + ", description=" + this.description + ", example=" + this.example + ")";
        }
    }
}

