/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.monitor.tracer;

import io.opentelemetry.api.trace.Span;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetlinks.core.monitor.tracer.NoopTracer;
import org.jetlinks.core.monitor.tracer.ProxyTracer;
import org.jetlinks.core.trace.FluxTracer;
import org.jetlinks.core.trace.MonoTracer;
import org.jetlinks.core.trace.ReactiveSpan;
import org.jetlinks.core.trace.ReactiveSpanBuilder;
import org.jetlinks.core.trace.ReactiveTracerBuilder;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public interface Tracer {
    public static Tracer lazy(Supplier<Tracer> lazy) {
        return new ProxyTracer(lazy);
    }

    public static Tracer noop() {
        return NoopTracer.INSTANCE;
    }

    public <E> FluxTracer<E> traceFlux(String var1, Consumer<ReactiveTracerBuilder<FluxTracer<E>, E>> var2);

    default public <E> FluxTracer<E> traceFlux(CharSequence operation, Consumer<ReactiveTracerBuilder<FluxTracer<E>, E>> consumer) {
        return this.traceFlux(operation.toString(), consumer);
    }

    default public <E> FluxTracer<E> traceFlux(String operation) {
        return this.traceFlux(operation, (ReactiveTracerBuilder<FluxTracer<E>, E> ignore) -> {});
    }

    default public <E> FluxTracer<E> traceFlux(CharSequence operation) {
        return this.traceFlux(operation, (ReactiveTracerBuilder<FluxTracer<E>, E> ignore) -> {});
    }

    default public <E> FluxTracer<E> traceFlux(String operation, BiConsumer<ContextView, ReactiveSpanBuilder> consumer) {
        return this.traceFlux(operation, (ReactiveTracerBuilder<FluxTracer<E>, E> builder) -> builder.onSubscription(consumer));
    }

    default public <E> FluxTracer<E> traceFlux(CharSequence operation, BiConsumer<ContextView, ReactiveSpanBuilder> consumer) {
        return this.traceFlux(operation, (ReactiveTracerBuilder<FluxTracer<E>, E> builder) -> builder.onSubscription(consumer));
    }

    public <E> MonoTracer<E> traceMono(String var1, Consumer<ReactiveTracerBuilder<MonoTracer<E>, E>> var2);

    default public <E> MonoTracer<E> traceMono(CharSequence operation, Consumer<ReactiveTracerBuilder<MonoTracer<E>, E>> consumer) {
        return this.traceMono(operation.toString(), consumer);
    }

    default public <E> MonoTracer<E> traceMono(CharSequence operation) {
        return this.traceMono(operation, (ReactiveTracerBuilder<MonoTracer<E>, E> ignore) -> {});
    }

    default public <E> MonoTracer<E> traceMono(String operation) {
        return this.traceMono(operation, (ReactiveTracerBuilder<MonoTracer<E>, E> ignore) -> {});
    }

    default public <E> MonoTracer<E> traceMono(String operation, BiConsumer<ContextView, ReactiveSpanBuilder> consumer) {
        return this.traceMono(operation, (ReactiveTracerBuilder<MonoTracer<E>, E> builder) -> builder.onSubscription(consumer));
    }

    default public <E> E traceBlocking(CharSequence operation, ContextView ctx, Function<ReactiveSpan, E> task) {
        return task.apply(ReactiveSpan.wrap(Span.current()));
    }

    default public <E> E traceBlocking(CharSequence operation, Function<ReactiveSpan, E> task) {
        return this.traceBlocking(operation, (ContextView)Context.empty(), task);
    }
}

