/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.monitor.tracer;

import io.opentelemetry.context.Context;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SharedPathString;
import org.jetlinks.core.monitor.tracer.Tracer;
import org.jetlinks.core.trace.FluxTracer;
import org.jetlinks.core.trace.MonoTracer;
import org.jetlinks.core.trace.ReactiveSpan;
import org.jetlinks.core.trace.ReactiveTracerBuilder;
import org.jetlinks.core.trace.TraceHolder;
import reactor.util.context.ContextView;

public class SimpleTracer
implements Tracer {
    private final SeparatedCharSequence tracePrefix;

    public SimpleTracer(String tracePrefix) {
        this(SharedPathString.of(tracePrefix));
    }

    public SimpleTracer(SeparatedCharSequence tracePrefix) {
        this.tracePrefix = tracePrefix;
    }

    @Override
    public <E> FluxTracer<E> traceFlux(CharSequence operation, Consumer<ReactiveTracerBuilder<FluxTracer<E>, E>> consumer) {
        SeparatedCharSequence spanName = this.tracePrefix.append(operation);
        if (TraceHolder.isEnabled(spanName)) {
            ReactiveTracerBuilder builder = FluxTracer.builder();
            consumer.accept(builder);
            builder.spanName(spanName);
            this.handleTraceBuilder(builder);
            return builder.build();
        }
        return FluxTracer.unsupported();
    }

    @Override
    public <E> FluxTracer<E> traceFlux(String operation, Consumer<ReactiveTracerBuilder<FluxTracer<E>, E>> consumer) {
        return this.traceFlux((CharSequence)operation, consumer);
    }

    @Override
    public <E> MonoTracer<E> traceMono(String operation, Consumer<ReactiveTracerBuilder<MonoTracer<E>, E>> consumer) {
        return this.traceMono((CharSequence)operation, consumer);
    }

    @Override
    public <E> MonoTracer<E> traceMono(CharSequence operation, Consumer<ReactiveTracerBuilder<MonoTracer<E>, E>> consumer) {
        SeparatedCharSequence spanName = this.tracePrefix.append(operation);
        if (TraceHolder.isEnabled(spanName)) {
            ReactiveTracerBuilder builder = MonoTracer.builder();
            consumer.accept(builder);
            this.handleTraceBuilder(builder);
            builder.spanName(spanName);
            return builder.build();
        }
        return MonoTracer.unsupported();
    }

    @Override
    public <E> E traceBlocking(CharSequence operation, Function<ReactiveSpan, E> task) {
        SeparatedCharSequence spanName = this.tracePrefix.append(operation);
        return TraceHolder.traceBlocking(spanName, task);
    }

    @Override
    public <E> E traceBlocking(CharSequence operation, ContextView ctx, Function<ReactiveSpan, E> task) {
        SeparatedCharSequence spanName = this.tracePrefix.append(operation);
        return TraceHolder.traceBlocking((Context)ctx.getOrDefault(Context.class, (Object)Context.current()), spanName, task);
    }

    protected void handleTraceBuilder(ReactiveTracerBuilder<?, ?> builder) {
    }
}

