/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.monitor.logger;

import java.util.function.Supplier;
import org.jetlinks.core.monitor.logger.BridgeLoggerSlf4j;
import org.jetlinks.core.monitor.logger.CompositeLogger;
import org.jetlinks.core.monitor.logger.NoopLogger;
import org.jetlinks.core.monitor.logger.ProxyLogger;
import org.slf4j.event.Level;

public interface Logger {
    public static Logger composite(Logger ... loggers) {
        return new CompositeLogger(loggers);
    }

    public static Logger lazy(Supplier<Logger> lazy) {
        return new ProxyLogger(lazy);
    }

    public static Logger noop() {
        return NoopLogger.INSTANCE;
    }

    default public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    default public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    default public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    default public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    default public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    default public void trace(String message, Object ... args) {
        this.log(Level.TRACE, message, args);
    }

    default public void debug(String message, Object ... args) {
        this.log(Level.DEBUG, message, args);
    }

    default public void info(String message, Object ... args) {
        this.log(Level.INFO, message, args);
    }

    default public void warn(String message, Object ... args) {
        this.log(Level.WARN, message, args);
    }

    default public void error(String message, Object ... args) {
        this.log(Level.ERROR, message, args);
    }

    default public boolean isEnabled(Level level) {
        return true;
    }

    default public String getName() {
        return this.toString();
    }

    public void log(Level var1, String var2, Object ... var3);

    default public org.slf4j.Logger slf4j() {
        return new BridgeLoggerSlf4j(this.getName(), this);
    }
}

