/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.monitor.logger;

import org.jetlinks.core.monitor.logger.Logger;
import org.slf4j.event.Level;

class CompositeLogger
implements Logger {
    private final Logger[] loggers;

    @Override
    public boolean isEnabled(Level level) {
        for (Logger logger : this.loggers) {
            if (!logger.isEnabled(level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void log(Level level, String message, Object ... args) {
        for (Logger logger : this.loggers) {
            if (!logger.isEnabled(level)) continue;
            logger.log(level, message, args);
        }
    }

    public CompositeLogger(Logger[] loggers) {
        this.loggers = loggers;
    }
}

