/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.unit;

import java.util.HashMap;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hswebframework.web.dict.Dict;
import org.hswebframework.web.dict.I18nEnumDict;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.metadata.unit.ValueUnit;

@Dict(value="unify-unit")
public enum UnifyUnit implements ValueUnit,
I18nEnumDict<String>
{
    percent("\u767e\u5206\u6bd4", "%", "\u5e38\u7528\u5355\u4f4d", "\u767e\u5206\u6bd4(%)"),
    count("\u6b21", "count", "\u5e38\u7528\u5355\u4f4d", "\u6b21"),
    turnPerSeconds("\u8f6c\u6bcf\u5206\u949f", "r/min", "\u5e38\u7528\u5355\u4f4d", "\u8f6c\u6bcf\u5206\u949f"),
    nanometer("\u7eb3\u7c73", "nm", "\u957f\u5ea6\u5355\u4f4d", "\u957f\u5ea6\u5355\u4f4d:\u7eb3\u7c73(nm)"),
    micron("\u5fae\u7c73", "\u03bcm", "\u957f\u5ea6\u5355\u4f4d", "\u957f\u5ea6\u5355\u4f4d:\u5fae\u7c73(\u03bcm)"),
    millimeter("\u6beb\u7c73", "mm", "\u957f\u5ea6\u5355\u4f4d", "\u957f\u5ea6\u5355\u4f4d:\u6beb\u7c73(mm)"),
    centimeter("\u5398\u7c73", "cm", "\u957f\u5ea6\u5355\u4f4d", "\u957f\u5ea6\u5355\u4f4d:\u5398\u7c73(cm)"),
    meter("\u7c73", "m", "\u957f\u5ea6\u5355\u4f4d", "\u957f\u5ea6\u5355\u4f4d:\u7c73(m)"),
    kilometer("\u5343\u7c73", "km", "\u957f\u5ea6\u5355\u4f4d", "\u957f\u5ea6\u5355\u4f4d:\u5343\u7c73(km)"),
    squareMillimeter("\u5e73\u65b9\u6beb\u7c73", "mm\u00b2", "\u9762\u79ef\u5355\u4f4d", "\u9762\u79ef\u5355\u4f4d:\u5e73\u65b9\u6beb\u7c73(mm\u00b2)"),
    squareCentimeter("\u5e73\u65b9\u5398\u7c73", "cm\u00b2", "\u9762\u79ef\u5355\u4f4d", "\u9762\u79ef\u5355\u4f4d:\u5e73\u65b9\u5398\u7c73(cm\u00b2)"),
    squareMeter("\u5e73\u65b9\u7c73", "m\u00b2", "\u9762\u79ef\u5355\u4f4d", "\u9762\u79ef\u5355\u4f4d:\u5e73\u65b9\u7c73(m\u00b2)"),
    squareKilometer("\u5e73\u65b9\u5343\u7c73", "km\u00b2", "\u9762\u79ef\u5355\u4f4d", "\u9762\u79ef\u5355\u4f4d:\u5e73\u65b9\u5343\u7c73(km\u00b2)"),
    hectare("\u516c\u9877", "hm\u00b2", "\u9762\u79ef\u5355\u4f4d", "\u9762\u79ef\u5355\u4f4d:\u516c\u9877(hm\u00b2)"),
    days("\u5929", "d", "\u65f6\u95f4\u5355\u4f4d", "\u65f6\u95f4\u5355\u4f4d:\u5929(d)"),
    hour("\u5c0f\u65f6", "h", "\u65f6\u95f4\u5355\u4f4d", "\u65f6\u95f4\u5355\u4f4d:\u5c0f\u65f6(h)"),
    minutes("\u5206\u949f", "min", "\u65f6\u95f4\u5355\u4f4d", "\u65f6\u95f4\u5355\u4f4d:\u5206\u949f(m)"),
    seconds("\u79d2", "s", "\u65f6\u95f4\u5355\u4f4d", "\u65f6\u95f4\u5355\u4f4d:\u79d2(s)"),
    milliseconds("\u6beb\u79d2", "ms", "\u65f6\u95f4\u5355\u4f4d", "\u65f6\u95f4\u5355\u4f4d:\u6beb\u79d2(ms)"),
    microseconds("\u5fae\u79d2", "\u03bcs", "\u65f6\u95f4\u5355\u4f4d", "\u65f6\u95f4\u5355\u4f4d:\u5fae\u79d2(\u03bcs)"),
    nanoseconds("\u7eb3\u79d2", "ns", "\u65f6\u95f4\u5355\u4f4d", "\u65f6\u95f4\u5355\u4f4d:\u7eb3\u79d2(ns)"),
    cubicMillimeter("\u7acb\u65b9\u6beb\u7c73", "mm\u00b3", "\u4f53\u79ef\u5355\u4f4d", "\u4f53\u79ef\u5355\u4f4d:\u7acb\u65b9\u6beb\u7c73(mm\u00b3)"),
    cubicCentimeter("\u7acb\u65b9\u5398\u7c73", "cm\u00b3", "\u4f53\u79ef\u5355\u4f4d", "\u4f53\u79ef\u5355\u4f4d:\u7acb\u65b9\u5398\u7c73(cm\u00b3)"),
    cubicMeter("\u7acb\u65b9\u7c73", "m\u00b3", "\u4f53\u79ef\u5355\u4f4d", "\u4f53\u79ef\u5355\u4f4d:\u7acb\u65b9\u7c73(m\u00b3)"),
    cubicKilometer("\u7acb\u65b9\u5343\u7c73", "km\u00b3", "\u4f53\u79ef\u5355\u4f4d", "\u4f53\u79ef\u5355\u4f4d:\u7acb\u65b9\u5343\u7c73(km\u00b3)"),
    cubicMeterPerSec("\u7acb\u65b9\u7c73\u6bcf\u79d2", "m\u00b3/s", "\u6d41\u91cf\u5355\u4f4d", "\u6d41\u91cf\u5355\u4f4d:\u7acb\u65b9\u7c73\u6bcf\u79d2(m\u00b3/s)"),
    cubicKilometerPerSec("\u7acb\u65b9\u5343\u7c73\u6bcf\u79d2", "km\u00b3/s", "\u6d41\u91cf\u5355\u4f4d", "\u6d41\u91cf\u5355\u4f4d:\u7acb\u65b9\u5343\u7c73\u6bcf\u79d2(km\u00b3/s)"),
    cubicCentimeterPerSec("\u7acb\u65b9\u5398\u7c73\u6bcf\u79d2", "cm\u00b3/s", "\u6d41\u91cf\u5355\u4f4d", "\u6d41\u91cf\u5355\u4f4d:\u7acb\u65b9\u5398\u7c73\u6bcf\u79d2(cm\u00b3/s)"),
    litrePerSec("\u5347\u6bcf\u79d2", "l/s", "\u6d41\u91cf\u5355\u4f4d", "\u6d41\u91cf\u5355\u4f4d:\u5347\u6bcf\u79d2(l/s)"),
    cubicMeterPerHour("\u7acb\u65b9\u7c73\u6bcf\u5c0f\u65f6", "m\u00b3/h", "\u6d41\u91cf\u5355\u4f4d", "\u6d41\u91cf\u5355\u4f4d:\u7acb\u65b9\u7c73\u6bcf\u5c0f\u65f6(m\u00b3/h)"),
    cubicKilometerPerHour("\u7acb\u65b9\u5343\u7c73\u6bcf\u5c0f\u65f6", "km\u00b3/h", "\u6d41\u91cf\u5355\u4f4d", "\u6d41\u91cf\u5355\u4f4d:\u7acb\u65b9\u5343\u7c73\u6bcf\u5c0f\u65f6(km\u00b3/h)"),
    cubicCentimeterPerHour("\u7acb\u65b9\u5398\u7c73\u6bcf\u5c0f\u65f6", "cm\u00b3/h", "\u6d41\u91cf\u5355\u4f4d", "\u6d41\u91cf\u5355\u4f4d:\u7acb\u65b9\u5398\u7c73\u6bcf\u5c0f\u65f6(cm\u00b3/h)"),
    litrePerHour("\u5347\u6bcf\u5c0f\u65f6", "l/h", "\u6d41\u91cf\u5355\u4f4d", "\u6d41\u91cf\u5355\u4f4d:\u5347\u6bcf\u5c0f\u65f6(l/h)"),
    milliliter("\u6beb\u5347", "mL", "\u5bb9\u79ef\u5355\u4f4d", "\u5bb9\u79ef\u5355\u4f4d:\u6beb\u5347(mL)"),
    litre("\u5347", "L", "\u5bb9\u79ef\u5355\u4f4d", "\u5bb9\u79ef\u5355\u4f4d:\u5347(L)"),
    milligram("\u6beb\u514b", "mg", "\u8d28\u91cf\u5355\u4f4d", "\u91cd\u91cf\u5355\u4f4d:\u6beb\u514b(mg)"),
    gramme("\u514b", "g", "\u8d28\u91cf\u5355\u4f4d", "\u91cd\u91cf\u5355\u4f4d:\u514b(g)"),
    kilogram("\u5343\u514b", "kg", "\u8d28\u91cf\u5355\u4f4d", "\u91cd\u91cf\u5355\u4f4d:\u5343\u514b(kg)"),
    ton("\u5428", "t", "\u8d28\u91cf\u5355\u4f4d", "\u91cd\u91cf\u5355\u4f4d:\u5428(t)"),
    pascal("\u5e15\u65af\u5361", "Pa", "\u538b\u529b\u5355\u4f4d", "\u538b\u529b\u5355\u4f4d:\u5e15\u65af\u5361(Pa)"),
    kiloPascal("\u5343\u5e15\u65af\u5361", "kPa", "\u538b\u529b\u5355\u4f4d", "\u538b\u529b\u5355\u4f4d:\u5343\u5e15\u65af\u5361(kPa)"),
    newton("\u725b\u987f", "N", "\u529b\u5355\u4f4d", "\u529b\u5355\u4f4d:\u725b\u987f(N)"),
    newtonMeter("\u725b\u00b7\u7c73", "N.m", "\u529b\u5355\u4f4d", "\u529b\u5355\u4f4d:\u725b\u00b7\u7c73(N.m)"),
    kelvin("\u5f00\u5c14\u6587", "K", "\u6e29\u5ea6\u5355\u4f4d", "\u6e29\u5ea6\u5355\u4f4d:\u5f00\u5c14\u6587(K)"),
    celsiusDegrees("\u6444\u6c0f\u5ea6", "\u2103", "\u6e29\u5ea6\u5355\u4f4d", "\u6e29\u5ea6\u5355\u4f4d:\u6444\u6c0f\u5ea6(\u2103)"),
    fahrenheit("\u534e\u6c0f\u5ea6", "\u2109", "\u6e29\u5ea6\u5355\u4f4d", "\u6e29\u5ea6\u5355\u4f4d:\u534e\u6c0f\u5ea6(\u2109)"),
    joule("\u7126\u8033", "J", "\u80fd\u91cf\u5355\u4f4d", "\u80fd\u5355\u4f4d:\u7126\u8033(J)"),
    cal("\u5361", "cal", "\u80fd\u91cf\u5355\u4f4d", "\u80fd\u5355\u4f4d:\u5361(cal)"),
    watt("\u74e6\u7279", "W", "\u529f\u7387\u5355\u4f4d", "\u529f\u7387\u5355\u4f4d:\u74e6\u7279(W)"),
    kilowatt("\u5343\u74e6\u7279", "kW", "\u529f\u7387\u5355\u4f4d", "\u529f\u7387\u5355\u4f4d:\u5343\u74e6\u7279(kW)"),
    radian("\u5f27\u5ea6", "rad", "\u89d2\u5ea6\u5355\u4f4d", "\u89d2\u5ea6\u5355\u4f4d:\u5f27\u5ea6(rad)"),
    degrees("\u5ea6", "\u00b0", "\u89d2\u5ea6\u5355\u4f4d", "\u89d2\u5ea6\u5355\u4f4d:\u5ea6(\u00b0)"),
    fen("[\u89d2]\u5206", "\u2032", "\u89d2\u5ea6\u5355\u4f4d", "\u89d2\u5ea6\u5355\u4f4d:\u5206(\u2032)"),
    angleSeconds("[\u89d2]\u79d2", "\u2033", "\u89d2\u5ea6\u5355\u4f4d", "\u89d2\u5ea6\u5355\u4f4d:\u5ea6(\u2033)"),
    hertz("\u8d6b\u5179", "Hz", "\u9891\u7387\u5355\u4f4d", "\u9891\u7387\u5355\u4f4d:\u8d6b\u5179(Hz)"),
    megahertz("\u5146\u8d6b\u5179", "MHz", "\u9891\u7387\u5355\u4f4d", "\u9891\u7387\u5355\u4f4d:\u5146\u8d6b\u5179(MHz)"),
    ghertz("G\u8d6b\u5179", "GHz", "\u9891\u7387\u5355\u4f4d", "\u9891\u7387\u5355\u4f4d:G\u8d6b\u5179(GHz)"),
    mPerSec("\u7c73\u6bcf\u79d2", "m/s", "\u901f\u5ea6\u5355\u4f4d", "\u901f\u5ea6\u5355\u4f4d:\u7c73\u6bcf\u79d2(m/s)"),
    kmPerHr("\u5343\u7c73\u6bcf\u5c0f\u65f6", "km/h", "\u901f\u5ea6\u5355\u4f4d", "\u901f\u5ea6\u5355\u4f4d:\u5343\u7c73\u6bcf\u5c0f\u65f6(km/h)"),
    knots("\u8282", "kn", "\u901f\u5ea6\u5355\u4f4d", "\u901f\u5ea6\u5355\u4f4d:\u8282(kn)"),
    volt("\u4f0f\u7279", "V", "\u7535\u529b\u5355\u4f4d", "\u7535\u538b:\u4f0f\u7279(V)"),
    kiloVolt("\u5343\u4f0f", "kV", "\u7535\u529b\u5355\u4f4d", "\u7535\u538b:\u5343\u4f0f(kV)"),
    milliVolt("\u6beb\u4f0f", "mV", "\u7535\u529b\u5355\u4f4d", "\u7535\u538b:\u6beb\u4f0f(mV)"),
    microVolt("\u5fae\u4f0f", "\u03bcV", "\u7535\u529b\u5355\u4f4d", "\u7535\u538b:\u5fae\u4f0f(\u03bcV)"),
    ampere("\u5b89\u57f9", "A", "\u7535\u529b\u5355\u4f4d", "\u7535\u6d41:\u5b89\u57f9(A)"),
    milliAmpere("\u6beb\u5b89", "mA", "\u7535\u529b\u5355\u4f4d", "\u7535\u6d41:\u6beb\u5b89(mA)"),
    microAmpere("\u5fae\u5b89", "\u03bcA", "\u7535\u529b\u5355\u4f4d", "\u7535\u6d41:\u5fae\u5b89(\u03bcA)"),
    nanoAmpere("\u7eb3\u5b89", "nA", "\u7535\u529b\u5355\u4f4d", "\u7535\u6d41:\u7eb3\u5b89(nA)"),
    ohm("\u6b27\u59c6", "\u03a9", "\u7535\u529b\u5355\u4f4d", "\u7535\u963b:\u6b27\u59c6(\u03a9)"),
    kiloOhm("\u5343\u6b27", "K\u03a9", "\u7535\u529b\u5355\u4f4d", "\u7535\u963b:\u5343\u6b27(K\u03a9)"),
    millionOhm("\u5146\u6b27", "M\u03a9", "\u7535\u529b\u5355\u4f4d", "\u7535\u963b:\u5146\u6b27(M\u03a9)"),
    electronVolts("\u7535\u5b50\u4f0f", "eV", "\u7535\u529b\u5355\u4f4d", "\u80fd\u5355\u4f4d:\u7535\u5b50\u4f0f(eV)"),
    kWattsHour("\u5343\u74e6\u00b7\u65f6", "kW\u00b7h", "\u7535\u529b\u5355\u4f4d", "\u80fd\u5355\u4f4d:\u5343\u74e6\u00b7\u65f6(kW\u00b7h)");

    private final String name;
    private final String symbol;
    private final String type;
    private final String description;

    @Override
    public String getId() {
        return this.name();
    }

    @Override
    public String format(Object value) {
        return String.format("%s%s", value, this.getSymbol());
    }

    static Function<Object, String> template(String strTemplate) {
        return o -> String.format(strTemplate, o);
    }

    public static UnifyUnit of(String value) {
        return Stream.of(UnifyUnit.values()).filter(unifyUnit -> unifyUnit.getId().equals(value) || unifyUnit.getSymbol().equals(value)).findFirst().orElse(null);
    }

    public String getValue() {
        return this.name();
    }

    public String getText() {
        return this.getName().concat("(").concat(this.getSymbol() + ")");
    }

    @Override
    public String getName() {
        return LocaleUtils.resolveMessage((String)("message.metadata.unify-unit." + this.name() + ".name"), (Locale)LocaleUtils.current(), (String)this.name, (Object[])new Object[0]);
    }

    @Override
    public String getDescription() {
        return this.getI18nMessage(LocaleUtils.current());
    }

    public Object getWriteJSONObject() {
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        jsonObject.put("id", this.getValue());
        jsonObject.put("value", this.getValue());
        jsonObject.put("text", this.getText());
        jsonObject.put("symbol", this.getSymbol());
        jsonObject.put("name", this.getName());
        jsonObject.put("type", this.getType());
        jsonObject.put("description", this.getDescription());
        return jsonObject;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public String getType() {
        return this.type;
    }

    private UnifyUnit(String name, String symbol, String type, String description) {
        this.name = name;
        this.symbol = symbol;
        this.type = type;
        this.description = description;
    }
}

