/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.ValidateResult;
import org.jetlinks.core.metadata.types.AbstractType;
import org.springframework.util.CollectionUtils;

public class ArrayType
extends AbstractType<ArrayType>
implements DataType,
Converter<List<Object>> {
    public static final String ID = "array";
    private DataType elementType;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return LocaleUtils.resolveMessage((String)"message.metadata.type.array", (Locale)LocaleUtils.current(), (String)"\u6570\u7ec4", (Object[])new Object[0]);
    }

    public ArrayType elementType(DataType elementType) {
        this.elementType = elementType;
        return this;
    }

    @Override
    public ValidateResult validate(Object value) {
        Object listValue = this.convert(value);
        if (this.elementType != null && value instanceof Collection) {
            Iterator iterator = listValue.iterator();
            while (iterator.hasNext()) {
                Object data = iterator.next();
                ValidateResult result = this.elementType.validate(data);
                if (result.isSuccess()) continue;
                return result;
            }
        }
        return ValidateResult.success(listValue);
    }

    @Override
    public Object format(Object value) {
        if (this.elementType != null && value instanceof Collection) {
            Collection collection = (Collection)value;
            return new JSONArray(collection.stream().map(data -> this.elementType.format(data)).collect(Collectors.toList()));
        }
        return JSON.toJSON((Object)value);
    }

    @Override
    public List<Object> convert(Object value) {
        if (value.getClass().isArray()) {
            return CollectionUtils.arrayToList((Object)value).stream().map(val -> {
                if (this.elementType instanceof Converter) {
                    return ((Converter)((Object)this.elementType)).convert(val);
                }
                return val;
            }).collect(Collectors.toList());
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(val -> {
                if (this.elementType instanceof Converter) {
                    return ((Converter)((Object)this.elementType)).convert(val);
                }
                return val;
            }).collect(Collectors.toList());
        }
        if (value instanceof String) {
            return JSON.parseArray((String)String.valueOf(value));
        }
        return Collections.singletonList(value);
    }

    public DataType getElementType() {
        return this.elementType;
    }

    public void setElementType(DataType elementType) {
        this.elementType = elementType;
    }
}

