/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.function;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import lombok.NonNull;
import org.jetlinks.core.utils.SerializeUtils;

public class FunctionParameter
implements Externalizable {
    private static final long serialVersionUID = -6849794470754667710L;
    @NonNull
    private String name;
    private Object value;

    public String toString() {
        return this.name + "(" + this.value + ")";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        SerializeUtils.writeObject(this.value, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.value = SerializeUtils.readObject(in);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public FunctionParameter(@NonNull String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.value = value;
    }

    public FunctionParameter() {
    }
}

