/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.firmware;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.RepayableDeviceMessage;
import org.jetlinks.core.message.firmware.RequestFirmwareMessageReply;
import org.jetlinks.core.utils.SerializeUtils;

public class RequestFirmwareMessage
extends CommonDeviceMessage<RequestFirmwareMessage>
implements RepayableDeviceMessage<RequestFirmwareMessageReply> {
    private String currentVersion;
    private String requestVersion;

    @Override
    public MessageType getMessageType() {
        return MessageType.REQUEST_FIRMWARE;
    }

    @Override
    public MessageType getReplyType() {
        return MessageType.REQUEST_FIRMWARE_REPLY;
    }

    @Override
    public RequestFirmwareMessageReply newReply() {
        return (RequestFirmwareMessageReply)new RequestFirmwareMessageReply().from(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.currentVersion = SerializeUtils.readNullableUTF(in);
        this.requestVersion = SerializeUtils.readNullableUTF(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SerializeUtils.writeNullableUTF(this.currentVersion, out);
        SerializeUtils.writeNullableUTF(this.requestVersion, out);
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getRequestVersion() {
        return this.requestVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void setRequestVersion(String requestVersion) {
        this.requestVersion = requestVersion;
    }
}

