/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.firmware;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.jetlinks.core.message.CommonDeviceMessageReply;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.utils.SerializeUtils;

public class ReadFirmwareMessageReply
extends CommonDeviceMessageReply<ReadFirmwareMessageReply> {
    private String version;
    private Map<String, Object> properties;

    @Override
    public MessageType getMessageType() {
        return MessageType.READ_FIRMWARE_REPLY;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.version = SerializeUtils.readNullableUTF(in);
        if (this.properties == null) {
            this.properties = Maps.newHashMapWithExpectedSize((int)32);
        }
        SerializeUtils.readKeyValue(in, this.properties::put);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SerializeUtils.writeNullableUTF(this.version, out);
        SerializeUtils.writeKeyValue(this.properties, out);
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

