/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.net.URLCodec;
import org.springframework.util.StringUtils;

public class HttpUtils {
    static final URLCodec urlCodec = new URLCodec();

    public static String urlDecode(String url) {
        return urlCodec.decode(url);
    }

    public static String urlEncode(String url) {
        return urlCodec.encode(url);
    }

    public static String getUrlPath(String url) {
        String path;
        if (!url.contains("://")) {
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
            url = "http://test" + url;
        }
        if (!(path = new URL(url).getPath()).startsWith("/")) {
            return "/".concat(path);
        }
        return path;
    }

    public static String createEncodedUrlParams(Map<?, ?> maps) {
        return maps.entrySet().stream().map(e -> HttpUtils.urlEncode(String.valueOf(e.getKey())) + "=" + HttpUtils.urlEncode(String.valueOf(e.getValue()))).collect(Collectors.joining("&"));
    }

    public static Map<String, String> parseEncodedUrlParams(String uriOrQuery) {
        return HttpUtils.parseEncodedUrlParams(uriOrQuery, LinkedHashMap::new);
    }

    public static Map<String, String> parseEncodedUrlParams(String uriOrQuery, Supplier<Map<String, String>> supplier) {
        if (StringUtils.isEmpty((Object)uriOrQuery)) {
            return Collections.emptyMap();
        }
        int queryIndex = uriOrQuery.indexOf("?");
        if (queryIndex >= 0) {
            uriOrQuery = uriOrQuery.substring(queryIndex + 1);
        }
        return Stream.of(uriOrQuery.split("[&]")).map(par -> par.split("[=]", 2)).collect(Collectors.toMap(arr -> HttpUtils.urlDecode(arr[0]), arr -> ((String[])arr).length > 1 ? HttpUtils.urlDecode(arr[1]) : "", (a, b) -> String.join((CharSequence)",", a, b), supplier));
    }

    public static String appendUrlParameter(String url, Map<?, ?> param) {
        return HttpUtils.appendUrlParameter(url, HttpUtils.createEncodedUrlParams(param));
    }

    public static String appendUrlParameter(String url, String param) {
        if (StringUtils.isEmpty((Object)url)) {
            return url;
        }
        if (url.contains("?")) {
            return url + "&" + param;
        }
        return url + "?" + param;
    }
}

