/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.http.Header;
import org.jetlinks.core.message.codec.http.HttpUtils;
import org.jetlinks.core.message.codec.http.MultiPart;
import org.jetlinks.core.message.codec.http.Part;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;

public interface HttpRequestMessage
extends EncodedMessage {
    @Nonnull
    default public String getPath() {
        return HttpUtils.getUrlPath(this.getUrl());
    }

    @Nonnull
    public String getUrl();

    @Nonnull
    public HttpMethod getMethod();

    @Nullable
    public MediaType getContentType();

    @Nonnull
    public List<Header> getHeaders();

    @Nullable
    public Map<String, String> getQueryParameters();

    @Nullable
    default public Map<String, String> getRequestParam() {
        if (MediaType.APPLICATION_FORM_URLENCODED.includes(this.getContentType())) {
            return HttpUtils.parseEncodedUrlParams(this.payloadAsString());
        }
        return Collections.emptyMap();
    }

    default public Optional<MultiPart> multiPart() {
        return Optional.empty();
    }

    default public Object parseBody() {
        if (MediaType.APPLICATION_JSON.includes(this.getContentType())) {
            return JSON.parse((byte[])this.payloadAsBytes(), (Feature[])new Feature[0]);
        }
        if (MediaType.APPLICATION_FORM_URLENCODED.includes(this.getContentType())) {
            return HttpUtils.parseEncodedUrlParams(this.payloadAsString());
        }
        return this.payloadAsString();
    }

    default public Optional<Header> getHeader(String name) {
        return this.getHeaders().stream().filter(header -> header.getName().equals(name)).findFirst();
    }

    default public Optional<String> getQueryParameter(String name) {
        return Optional.ofNullable(this.getQueryParameters()).map(map -> (String)map.get(name));
    }

    default public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMethod()).append(" ").append(this.getPath());
        if (!CollectionUtils.isEmpty(this.getQueryParameters())) {
            builder.append("?").append(this.getQueryParameters().entrySet().stream().map(e -> ((String)e.getKey()).concat("=").concat((String)e.getValue())).collect(Collectors.joining("&"))).append("\n");
        } else {
            builder.append("\n");
        }
        for (Header header : this.getHeaders()) {
            builder.append(header.getName()).append(": ").append(String.join((CharSequence)",", header.getValue())).append("\n");
        }
        if (this.multiPart().isPresent()) {
            this.multiPart().ifPresent(parts -> {
                builder.append("\n");
                for (Part part : parts.getParts()) {
                    builder.append(part).append("\n");
                }
            });
        } else {
            ByteBuf payload = this.getPayload();
            if (payload.readableBytes() == 0) {
                return builder.toString();
            }
            builder.append("\n");
            if (ByteBufUtil.isText((ByteBuf)payload, (Charset)StandardCharsets.UTF_8)) {
                builder.append(payload.toString(StandardCharsets.UTF_8));
            } else {
                ByteBufUtil.appendPrettyHexDump((StringBuilder)builder, (ByteBuf)payload);
            }
        }
        return builder.toString();
    }
}

