/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import javax.annotation.Nonnull;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.trace.FluxTracer;
import org.jetlinks.core.trace.ProtocolTracer;
import reactor.core.publisher.Flux;

public class TraceDeviceMessageCodec
implements DeviceMessageCodec {
    private final String protocolId;
    private final DeviceMessageCodec target;

    @Override
    public Transport getSupportTransport() {
        return this.target.getSupportTransport();
    }

    @Nonnull
    public Flux<? extends Message> decode(@Nonnull MessageDecodeContext context) {
        return (Flux)Flux.from(this.target.decode(context)).as(FluxTracer.create(ProtocolTracer.SpanName.decode0(this.protocolId)));
    }

    @Nonnull
    public Flux<? extends EncodedMessage> encode(@Nonnull MessageEncodeContext context) {
        return (Flux)Flux.from(this.target.encode(context)).as(FluxTracer.create(ProtocolTracer.SpanName.encode0(this.protocolId)));
    }

    public TraceDeviceMessageCodec(String protocolId, DeviceMessageCodec target) {
        this.protocolId = protocolId;
        this.target = target;
    }
}

