/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.mqtt.MqttProperties;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.SimpleMqttMessage;
import org.jetlinks.core.utils.StringBuilderUtils;

public interface MqttMessage
extends EncodedMessage {
    public static MqttMessage create(String topic, ByteBuf payload) {
        return MqttMessage.builder().topic(topic).payload(payload).build();
    }

    public static MqttMessage create(String topic, ByteBuf payload, int qos) {
        return MqttMessage.builder().topic(topic).payload(payload).qosLevel(qos).build();
    }

    public static SimpleMqttMessage.SimpleMqttMessageBuilder builder() {
        return SimpleMqttMessage.builder();
    }

    @Nonnull
    public String getTopic();

    public String getClientId();

    public int getMessageId();

    default public boolean isWill() {
        return false;
    }

    default public int getQosLevel() {
        return 0;
    }

    default public boolean isDup() {
        return false;
    }

    default public boolean isRetain() {
        return false;
    }

    default public MqttProperties getProperties() {
        return MqttProperties.NO_PROPERTIES;
    }

    default public String print() {
        return StringBuilderUtils.buildString(this, (msg, builder) -> {
            builder.append("qos").append(this.getQosLevel()).append(" ").append(this.getTopic()).append("\n").append("messageId: ").append(this.getMessageId()).append("\n").append("dup: ").append(this.isDup()).append("\n").append("retain: ").append(this.isRetain()).append("\n").append("will: ").append(this.isWill()).append("\n\n");
            ByteBuf payload = this.getPayload();
            if (ByteBufUtil.isText((ByteBuf)payload, (Charset)StandardCharsets.UTF_8)) {
                builder.append(payload.toString(StandardCharsets.UTF_8));
            } else {
                ByteBufUtil.appendPrettyHexDump((StringBuilder)builder, (ByteBuf)payload);
            }
        });
    }
}

