/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.server.ClientConnection;
import org.jetlinks.core.server.session.DeviceSession;
import reactor.core.publisher.Mono;

public interface FromDeviceMessageContext
extends MessageDecodeContext {
    public DeviceSession getSession();

    default public ClientConnection getConnection() {
        return null;
    }

    @Override
    @Nullable
    default public DeviceOperator getDevice() {
        return this.getSession().getOperator();
    }

    public static FromDeviceMessageContext of(final DeviceSession session, final EncodedMessage message) {
        return new FromDeviceMessageContext(){

            @Override
            public DeviceSession getSession() {
                return session;
            }

            @Override
            @Nonnull
            public EncodedMessage getMessage() {
                return message;
            }
        };
    }

    public static FromDeviceMessageContext of(final DeviceSession session, final EncodedMessage message, final DeviceRegistry registry) {
        return new FromDeviceMessageContext(){

            @Override
            public DeviceSession getSession() {
                return session;
            }

            @Override
            @Nonnull
            public EncodedMessage getMessage() {
                return message;
            }

            @Override
            public Mono<DeviceOperator> getDevice(String deviceId) {
                return registry.getDevice(deviceId);
            }
        };
    }

    public static FromDeviceMessageContext of(final DeviceSession session, final EncodedMessage message, final DeviceRegistry registry, final Function<DeviceMessage, Mono<Void>> handler) {
        return new FromDeviceMessageContext(){

            @Override
            public DeviceSession getSession() {
                return session;
            }

            @Override
            @Nonnull
            public EncodedMessage getMessage() {
                return message;
            }

            @Override
            public Mono<DeviceOperator> getDevice(String deviceId) {
                return registry.getDevice(deviceId);
            }

            @Override
            public Mono<Void> handleMessage(DeviceMessage message2) {
                return (Mono)handler.apply(message2);
            }
        };
    }

    public static FromDeviceMessageContext of(final DeviceSession session, final EncodedMessage message, final DeviceRegistry registry, final ClientConnection connection, final Function<DeviceMessage, Mono<Void>> handler) {
        return new FromDeviceMessageContext(){

            @Override
            public ClientConnection getConnection() {
                return connection;
            }

            @Override
            public DeviceSession getSession() {
                return session;
            }

            @Override
            @Nonnull
            public EncodedMessage getMessage() {
                return message;
            }

            @Override
            public Mono<DeviceOperator> getDevice(String deviceId) {
                return registry.getDevice(deviceId);
            }

            @Override
            public Mono<Void> handleMessage(DeviceMessage message2) {
                return (Mono)handler.apply(message2);
            }
        };
    }
}

