/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.message.codec.EmptyMessage;
import org.jetlinks.core.message.codec.MessagePayloadType;
import org.jetlinks.core.message.codec.SimpleEncodedMessage;

public interface EncodedMessage {
    @Nonnull
    public ByteBuf getPayload();

    default public String payloadAsString() {
        return this.getPayload().toString(StandardCharsets.UTF_8);
    }

    default public JSONObject payloadAsJson() {
        return (JSONObject)JSON.parse((byte[])this.payloadAsBytes(), (Feature[])new Feature[0]);
    }

    default public JSONArray payloadAsJsonArray() {
        return (JSONArray)JSON.parse((byte[])this.payloadAsBytes(), (Feature[])new Feature[0]);
    }

    default public byte[] payloadAsBytes() {
        return ByteBufUtil.getBytes((ByteBuf)this.getPayload());
    }

    @Deprecated
    default public byte[] getBytes() {
        return ByteBufUtil.getBytes((ByteBuf)this.getPayload());
    }

    default public byte[] getBytes(int offset, int len) {
        return ByteBufUtil.getBytes((ByteBuf)this.getPayload(), (int)offset, (int)len);
    }

    @Nullable
    @Deprecated
    default public MessagePayloadType getPayloadType() {
        return MessagePayloadType.JSON;
    }

    public static EmptyMessage empty() {
        return EmptyMessage.INSTANCE;
    }

    public static EncodedMessage simple(byte[] data) {
        return EncodedMessage.simple(Unpooled.wrappedBuffer((byte[])data), MessagePayloadType.BINARY);
    }

    public static EncodedMessage simple(ByteBuf data) {
        return EncodedMessage.simple(data, MessagePayloadType.BINARY);
    }

    public static EncodedMessage simple(ByteBuf data, MessagePayloadType payloadType) {
        return SimpleEncodedMessage.of(data, payloadType);
    }
}

