/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nonnull;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.jetlinks.core.message.codec.CoapMessage;
import org.jetlinks.core.message.codec.CoapResponseMessage;
import org.springframework.util.CollectionUtils;

public class CoapExchangeMessage
implements CoapMessage {
    protected CoapExchange exchange;
    static byte[] empty = new byte[0];

    @Override
    @Nonnull
    public CoAP.Code getCode() {
        return this.exchange.getRequestCode();
    }

    public CoapExchangeMessage(CoapExchange exchange) {
        this.exchange = exchange;
    }

    public void response(CoAP.ResponseCode code) {
        Response response = new Response(code);
        this.exchange.advanced().sendResponse(response);
    }

    public void response(CoAP.ResponseCode code, byte[] body) {
        Response response = new Response(code);
        response.setBytes(body);
        this.exchange.advanced().sendResponse(response);
    }

    public void response(CoapResponseMessage message) {
        byte[] payload;
        Response response = new Response(message.getCode());
        if (!CollectionUtils.isEmpty(message.getOptions())) {
            message.getOptions().forEach(arg_0 -> ((OptionSet)response.getOptions()).addOption(arg_0));
        }
        if ((payload = message.payloadAsBytes()).length > 0) {
            response.setPayload(payload);
        }
        this.exchange.advanced().sendResponse(response);
    }

    @Override
    @Nonnull
    public ByteBuf getPayload() {
        if (this.exchange.getRequestPayload() == null) {
            return Unpooled.wrappedBuffer((byte[])empty);
        }
        return Unpooled.wrappedBuffer((byte[])this.exchange.getRequestPayload());
    }

    public String toString() {
        return this.print(true);
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.exchange.getRequestOptions().getUriPathString();
    }

    @Override
    @Nonnull
    public List<Option> getOptions() {
        return this.exchange.getRequestOptions().asSortedList();
    }

    public CoapExchange getExchange() {
        return this.exchange;
    }
}

