/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.UpdateTingTagsMessage;
import org.jetlinks.core.utils.SerializeUtils;

public class UpdateTagMessage
extends CommonDeviceMessage<UpdateTagMessage>
implements UpdateTingTagsMessage {
    private Map<String, Object> tags;

    @Override
    public Map<String, Object> getTags() {
        return this.tags == null ? Collections.emptyMap() : this.tags;
    }

    public synchronized UpdateTagMessage tag(String tag, Object value) {
        if (value == null) {
            return this;
        }
        if (this.tags == null) {
            this.tags = new ConcurrentHashMap<String, Object>();
        }
        this.tags.put(tag, value);
        return this;
    }

    @Override
    public synchronized UpdateTagMessage tags(Map<String, Object> tags) {
        if (tags == null) {
            return this;
        }
        if (this.tags == null) {
            this.tags = new ConcurrentHashMap<String, Object>(Maps.filterValues(tags, Objects::nonNull));
            return this;
        }
        this.tags.putAll(tags);
        return this;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.UPDATE_TAG;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.tags((Map)jsonObject.getJSONObject("tags"));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        UpdateTingTagsMessage.super.writeExternal(out);
        SerializeUtils.writeKeyValue(this.tags, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        UpdateTingTagsMessage.super.readExternal(in);
        SerializeUtils.readKeyValue(in, this::tag);
    }

    public void setTags(Map<String, Object> tags) {
        this.tags = tags;
    }
}

