/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jetlinks.core.Routable;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.things.ThingId;
import org.jetlinks.core.things.ThingType;
import org.jetlinks.core.utils.SerializeUtils;

public interface ThingMessage
extends Message,
Routable {
    public String getThingType();

    public String getThingId();

    public ThingMessage messageId(String var1);

    public ThingMessage thingId(String var1, String var2);

    public ThingMessage timestamp(long var1);

    default public ThingMessage thingId(ThingType thingType, String thingId) {
        return this.thingId(thingType.getId(), thingId);
    }

    default public ThingMessage thingId(ThingId thingId) {
        return this.thingId(thingId.getType(), thingId.getId());
    }

    @Override
    default public ThingMessage copy() {
        return (ThingMessage)Message.super.copy();
    }

    @Override
    default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        SerializeUtils.readKeyValue(in, this::addHeader);
        this.thingId(SerializeUtils.readNullableUTF(in), SerializeUtils.readNullableUTF(in));
        this.messageId(SerializeUtils.readNullableUTF(in));
        this.timestamp(in.readLong());
    }

    @Override
    default public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeKeyValue(this.getHeaders(), out);
        SerializeUtils.writeNullableUTF(this.getThingType(), out);
        SerializeUtils.writeNullableUTF(this.getThingId(), out);
        SerializeUtils.writeNullableUTF(this.getMessageId(), out);
        out.writeLong(this.getTimestamp());
    }

    @Override
    default public Object routeKey() {
        return this.getHeaderOrElse(Headers.routeKey, this::getThingId);
    }
}

