/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetlinks.core.device.DeviceThingType;
import org.jetlinks.core.message.AcknowledgeDeviceMessage;
import org.jetlinks.core.message.BatchMessage;
import org.jetlinks.core.message.ChildDeviceMessage;
import org.jetlinks.core.message.ChildDeviceMessageReply;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.CommonDeviceMessageReply;
import org.jetlinks.core.message.DefaultBroadcastMessage;
import org.jetlinks.core.message.DefaultUpdateTingTagsMessage;
import org.jetlinks.core.message.DerivedMetadataMessage;
import org.jetlinks.core.message.DeviceLogMessage;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceOfflineMessage;
import org.jetlinks.core.message.DeviceOnlineMessage;
import org.jetlinks.core.message.DeviceRegisterMessage;
import org.jetlinks.core.message.DeviceUnRegisterMessage;
import org.jetlinks.core.message.DirectDeviceMessage;
import org.jetlinks.core.message.DisconnectDeviceMessage;
import org.jetlinks.core.message.DisconnectDeviceMessageReply;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.message.UpdateTagMessage;
import org.jetlinks.core.message.collector.ReadCollectorDataMessage;
import org.jetlinks.core.message.collector.ReadCollectorDataMessageReply;
import org.jetlinks.core.message.collector.ReportCollectorDataMessage;
import org.jetlinks.core.message.collector.WriteCollectorDataMessage;
import org.jetlinks.core.message.collector.WriteCollectorDataMessageReply;
import org.jetlinks.core.message.event.DefaultEventMessage;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.message.firmware.ReadFirmwareMessage;
import org.jetlinks.core.message.firmware.ReadFirmwareMessageReply;
import org.jetlinks.core.message.firmware.ReportFirmwareMessage;
import org.jetlinks.core.message.firmware.RequestFirmwareMessage;
import org.jetlinks.core.message.firmware.RequestFirmwareMessageReply;
import org.jetlinks.core.message.firmware.UpgradeFirmwareMessage;
import org.jetlinks.core.message.firmware.UpgradeFirmwareMessageReply;
import org.jetlinks.core.message.firmware.UpgradeFirmwareProgressMessage;
import org.jetlinks.core.message.function.DefaultFunctionInvokeMessage;
import org.jetlinks.core.message.function.DefaultFunctionInvokeMessageReply;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.module.DefaultThingModuleMessage;
import org.jetlinks.core.message.module.DeviceModuleMessage;
import org.jetlinks.core.message.property.DefaultReadPropertyMessage;
import org.jetlinks.core.message.property.DefaultReadPropertyMessageReply;
import org.jetlinks.core.message.property.DefaultReportPropertyMessage;
import org.jetlinks.core.message.property.DefaultWritePropertyMessage;
import org.jetlinks.core.message.property.DefaultWritePropertyMessageReply;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.ReadPropertyMessageReply;
import org.jetlinks.core.message.property.ReportPropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import org.jetlinks.core.message.state.DeviceStateCheckMessage;
import org.jetlinks.core.message.state.DeviceStateCheckMessageReply;
import org.jetlinks.core.things.ThingId;

public enum MessageType {
    REPORT_PROPERTY(ReportPropertyMessage::new, DefaultReportPropertyMessage::new),
    READ_PROPERTY(ReadPropertyMessage::new, DefaultReadPropertyMessage::new),
    WRITE_PROPERTY(WritePropertyMessage::new, DefaultWritePropertyMessage::new),
    READ_PROPERTY_REPLY(ReadPropertyMessageReply::new, DefaultReadPropertyMessageReply::new),
    WRITE_PROPERTY_REPLY(WritePropertyMessageReply::new, DefaultWritePropertyMessageReply::new),
    INVOKE_FUNCTION(FunctionInvokeMessage::new, DefaultFunctionInvokeMessage::new),
    INVOKE_FUNCTION_REPLY(FunctionInvokeMessageReply::new, DefaultFunctionInvokeMessageReply::new),
    EVENT(EventMessage::new, DefaultEventMessage::new),
    BROADCAST(DefaultBroadcastMessage::new),
    ONLINE(DeviceOnlineMessage::new),
    OFFLINE(DeviceOfflineMessage::new),
    REGISTER(DeviceRegisterMessage::new),
    UN_REGISTER(DeviceUnRegisterMessage::new),
    DISCONNECT(DisconnectDeviceMessage::new),
    DISCONNECT_REPLY(DisconnectDeviceMessageReply::new),
    DERIVED_METADATA(DerivedMetadataMessage::new),
    CHILD(ChildDeviceMessage::new),
    CHILD_REPLY(ChildDeviceMessageReply::new),
    READ_FIRMWARE(ReadFirmwareMessage::new),
    READ_FIRMWARE_REPLY(ReadFirmwareMessageReply::new),
    REPORT_FIRMWARE(ReportFirmwareMessage::new),
    REQUEST_FIRMWARE(RequestFirmwareMessage::new),
    REQUEST_FIRMWARE_REPLY(RequestFirmwareMessageReply::new),
    UPGRADE_FIRMWARE(UpgradeFirmwareMessage::new),
    UPGRADE_FIRMWARE_REPLY(UpgradeFirmwareMessageReply::new),
    UPGRADE_FIRMWARE_PROGRESS(UpgradeFirmwareProgressMessage::new),
    DIRECT(DirectDeviceMessage::new),
    UPDATE_TAG(UpdateTagMessage::new, DefaultUpdateTingTagsMessage::new),
    LOG(DeviceLogMessage::new),
    ACKNOWLEDGE(AcknowledgeDeviceMessage::new),
    STATE_CHECK(DeviceStateCheckMessage::new),
    STATE_CHECK_REPLY(DeviceStateCheckMessageReply::new),
    REPORT_COLLECTOR(ReportCollectorDataMessage::new),
    READ_COLLECTOR_DATA(ReadCollectorDataMessage::new),
    READ_COLLECTOR_DATA_REPLY(ReadCollectorDataMessageReply::new),
    WRITE_COLLECTOR_DATA(WriteCollectorDataMessage::new),
    WRITE_COLLECTOR_DATA_REPLY(WriteCollectorDataMessageReply::new),
    BATCH(BatchMessage::new),
    MODULE(DeviceModuleMessage::new, DefaultThingModuleMessage::new),
    UNKNOWN(null){

        @Override
        public <T extends Message> T convert(Map<String, Object> map) {
            if (map.containsKey("success")) {
                ChildDeviceMessageReply reply = new ChildDeviceMessageReply();
                ((CommonDeviceMessageReply)reply).fromJson(new JSONObject(map));
                return (T)reply;
            }
            CommonDeviceMessage reply = new CommonDeviceMessage();
            reply.fromJson(new JSONObject(map));
            return (T)reply;
        }
    };

    final Supplier<? extends Message> deviceInstance;
    final Supplier<? extends Message> thingInstance;
    private static final Map<String, MessageType> mapping;
    static final MessageType[] types;

    private MessageType(Supplier<Message> deviceInstance) {
        this(deviceInstance, null);
    }

    private MessageType(Supplier<? extends Message> deviceInstance, Supplier<? extends ThingMessage> thingInstance) {
        this.deviceInstance = deviceInstance;
        this.thingInstance = thingInstance;
    }

    public <T extends DeviceMessage> T forDevice() {
        if (this.deviceInstance == null) {
            return null;
        }
        Message msg = this.deviceInstance.get();
        if (msg instanceof DeviceMessage) {
            return (T)((DeviceMessage)msg);
        }
        return null;
    }

    public boolean iSupportDevice() {
        return this.deviceInstance != null;
    }

    public <T extends ThingMessage> T forThing() {
        if (null == this.thingInstance) {
            return null;
        }
        return (T)((ThingMessage)this.thingInstance.get());
    }

    public <T extends ThingMessage> T forThing(ThingId thingId) {
        return this.forThing(thingId.getType(), thingId.getId());
    }

    public <T extends ThingMessage> T forThing(String type, String id) {
        T thing = !DeviceThingType.device.name().equals(type) ? this.forThing() : this.forDevice();
        if (thing != null) {
            return (T)thing.thingId(type, id);
        }
        return null;
    }

    public <T extends Message> T convert(Map<String, Object> map) {
        Supplier<? extends Message> supplier = this.deviceInstance;
        if (this.deviceInstance != null) {
            Object type;
            if (this.thingInstance != null && (type = map.get("thingType")) != null && !DeviceThingType.device.name().equals(type)) {
                supplier = this.thingInstance;
            }
            Message msg = supplier.get();
            msg.fromJson(new JSONObject(map));
            return (T)msg;
        }
        return null;
    }

    public static <T extends Message> Optional<T> convertMessage(Map<String, Object> map) {
        return MessageType.of(map).map(type -> type.convert(map));
    }

    public static Optional<MessageType> of(String name) {
        return Optional.ofNullable(mapping.get(name));
    }

    public static Optional<MessageType> of(Map<String, Object> map) {
        Object msgType = map.get("messageType");
        if (msgType instanceof MessageType) {
            return Optional.of((MessageType)((Object)msgType));
        }
        if (msgType instanceof String) {
            return MessageType.of((String)msgType);
        }
        if (map.containsKey("event")) {
            return Optional.of(EVENT);
        }
        if (map.containsKey("functionId")) {
            return map.containsKey("inputs") ? Optional.of(INVOKE_FUNCTION) : Optional.of(INVOKE_FUNCTION_REPLY);
        }
        if (map.containsKey("properties")) {
            Object properties = map.get("properties");
            return properties instanceof Collection ? Optional.of(READ_PROPERTY) : Optional.of(READ_PROPERTY_REPLY);
        }
        if (map.containsKey("tags")) {
            return Optional.of(UPDATE_TAG);
        }
        if (map.containsKey("success")) {
            return Optional.of(ACKNOWLEDGE);
        }
        return Optional.of(UNKNOWN);
    }

    public static Message readExternal(ObjectInput input) {
        byte type = input.readByte();
        if (type >= types.length) {
            return null;
        }
        MessageType messageType = types[type];
        boolean isDevice = input.readBoolean();
        Message message = isDevice && messageType.deviceInstance != null ? messageType.deviceInstance.get() : (messageType.thingInstance != null ? messageType.thingInstance.get() : new CommonDeviceMessage());
        message.readExternal(input);
        return message;
    }

    public static void writeExternal(Message message, ObjectOutput output) {
        output.writeByte(message.getMessageType().ordinal());
        output.writeBoolean(message instanceof DeviceMessage);
        message.writeExternal(output);
    }

    static {
        mapping = new HashMap<String, MessageType>();
        for (MessageType value : MessageType.values()) {
            mapping.put(value.name().toLowerCase(), value);
            mapping.put(value.name().toUpperCase(), value);
        }
        types = MessageType.values();
    }
}

