/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.function.FunctionParameter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface FunctionInvokeMessageSender {
    public FunctionInvokeMessageSender custom(Consumer<FunctionInvokeMessage> var1);

    public FunctionInvokeMessageSender header(String var1, Object var2);

    public FunctionInvokeMessageSender addParameter(FunctionParameter var1);

    public FunctionInvokeMessageSender setParameter(List<FunctionParameter> var1);

    public FunctionInvokeMessageSender messageId(String var1);

    public Mono<FunctionInvokeMessageSender> validate();

    public Flux<FunctionInvokeMessageReply> send();

    default public Mono<Void> sendAndForget() {
        return this.header(Headers.sendAndForget, true).async().send().then();
    }

    default public FunctionInvokeMessageSender accept(Consumer<FunctionInvokeMessageSender> consumer) {
        consumer.accept(this);
        return this;
    }

    default public FunctionInvokeMessageSender addParameter(String name, Object value) {
        return this.addParameter(new FunctionParameter(name, value));
    }

    default public FunctionInvokeMessageSender setParameter(Map<String, Object> parameter) {
        parameter.forEach(this::addParameter);
        return this;
    }

    default public FunctionInvokeMessageSender timeout(Duration timeout) {
        return this.header(Headers.timeout, timeout.toMillis());
    }

    default public FunctionInvokeMessageSender async() {
        return this.async(true);
    }

    default public FunctionInvokeMessageSender async(Boolean async) {
        return this.header(Headers.async, async);
    }

    default public <T> FunctionInvokeMessageSender header(HeaderKey<T> header, T value) {
        return this.header(header.getKey(), value);
    }

    default public FunctionInvokeMessageSender headers(Map<String, Object> headers) {
        Objects.requireNonNull(headers).forEach(this::header);
        return this;
    }
}

