/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.lang;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.jetlinks.core.lang.AbstractSeparatedCharSequence;
import org.jetlinks.core.utils.StringBuilderUtils;

class SeparatedString3
extends AbstractSeparatedCharSequence {
    private final char separator;
    private final CharSequence s1;
    private final CharSequence s2;
    private final CharSequence s3;

    @Override
    public char separator() {
        return this.separator;
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public CharSequence get(int index) {
        if (index == 0) {
            return this.s1;
        }
        if (index == 1) {
            return this.s2;
        }
        if (index == 2) {
            return this.s3;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    @Override
    public int length() {
        return this.s1.length() + this.s2.length() + this.s3.length() + 2;
    }

    @Override
    public char charAt(int index) {
        int s1Length = this.s1.length();
        if (index < s1Length) {
            return this.s1.charAt(index);
        }
        if (index == s1Length) {
            return this.separator;
        }
        int idx = index - s1Length - 1;
        int s2Length = this.s2.length();
        if (idx < s2Length) {
            return this.s2.charAt(idx);
        }
        if (idx == s2Length) {
            return this.separator;
        }
        int s3Length = this.s3.length();
        if ((idx = idx - s2Length - 1) < s3Length) {
            return this.s3.charAt(idx);
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    @Override
    @Nonnull
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    @Nonnull
    public String toString() {
        return StringBuilderUtils.buildString(Character.valueOf(this.separator), this.s1, this.s2, this.s3, (s, c1, c2, c3, bd) -> bd.append((CharSequence)c1).append(s).append((CharSequence)c2).append(s).append((CharSequence)c3));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SeparatedString3)) {
            return false;
        }
        SeparatedString3 another = (SeparatedString3)obj;
        if (another.separator() != this.separator()) {
            return false;
        }
        return Objects.equals(this.s3, another.s3) && Objects.equals(this.s2, another.s2) && Objects.equals(this.s1, another.s1);
    }

    public SeparatedString3(char separator, CharSequence s1, CharSequence s2, CharSequence s3) {
        this.separator = separator;
        this.s1 = s1;
        this.s2 = s2;
        this.s3 = s3;
    }
}

